/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.delete.DeleteIndexClusterStateUpdateRequest;
import org.easysearch.cluster.AckedClusterStateUpdateTask;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.RestoreInProgress;
import org.easysearch.cluster.ack.AckedRequest;
import org.easysearch.cluster.ack.ClusterStateUpdateResponse;
import org.easysearch.cluster.block.ClusterBlocks;
import org.easysearch.cluster.metadata.DataStream;
import org.easysearch.cluster.metadata.IndexAbstraction;
import org.easysearch.cluster.metadata.IndexGraveyard;
import org.easysearch.cluster.metadata.IndexMetadata;
import org.easysearch.cluster.metadata.Metadata;
import org.easysearch.cluster.routing.RoutingTable;
import org.easysearch.cluster.routing.allocation.AllocationService;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.Priority;
import org.easysearch.common.collect.ImmutableOpenMap;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.util.set.Sets;
import org.easysearch.index.Index;
import org.easysearch.snapshots.RestoreService;
import org.easysearch.snapshots.SnapshotInProgressException;
import org.easysearch.snapshots.SnapshotsService;

public class MetadataDeleteIndexService {
    private static final Logger logger = LogManager.getLogger(MetadataDeleteIndexService.class);
    private final Settings settings;
    private final ClusterService clusterService;
    private final AllocationService allocationService;

    @Inject
    public MetadataDeleteIndexService(Settings settings, ClusterService clusterService, AllocationService allocationService) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
    }

    public void deleteIndices(final DeleteIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        if (request.indices() == null || request.indices().length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        this.clusterService.submitStateUpdateTask("delete-index " + Arrays.toString(request.indices()), new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return MetadataDeleteIndexService.this.deleteIndices(currentState, Sets.newHashSet(request.indices()));
            }
        });
    }

    public ClusterState deleteIndices(ClusterState currentState, Set<Index> indices) {
        Metadata meta = currentState.metadata();
        HashSet<Index> indicesToDelete = new HashSet<Index>();
        HashMap<Index, DataStream> backingIndices = new HashMap<Index, DataStream>();
        for (Index index : indices) {
            IndexMetadata im = meta.getIndexSafe(index);
            IndexAbstraction.DataStream parent = ((IndexAbstraction)meta.getIndicesLookup().get(im.getIndex().getName())).getParentDataStream();
            if (parent != null) {
                if (parent.getWriteIndex().equals(im)) {
                    throw new IllegalArgumentException("index [" + index.getName() + "] is the write index for data stream [" + parent.getName() + "] and cannot be deleted");
                }
                backingIndices.put(index, parent.getDataStream());
            }
            indicesToDelete.add(im.getIndex());
        }
        Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(currentState, indicesToDelete);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot delete indices that are being snapshotted: " + snapshottingIndices + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
        Metadata.Builder metadataBuilder = Metadata.builder(meta);
        ClusterBlocks.Builder clusterBlocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        IndexGraveyard.Builder graveyardBuilder = IndexGraveyard.builder(metadataBuilder.indexGraveyard());
        int previousGraveyardSize = graveyardBuilder.tombstones().size();
        for (Index index : indices) {
            String indexName = index.getName();
            logger.info("{} deleting index", (Object)index);
            routingTableBuilder.remove(indexName);
            clusterBlocksBuilder.removeIndexBlocks(indexName);
            metadataBuilder.remove(indexName);
            if (!backingIndices.containsKey(index)) continue;
            DataStream parent = metadataBuilder.dataStream(((DataStream)backingIndices.get(index)).getName());
            metadataBuilder.put(parent.removeBackingIndex(index));
        }
        IndexGraveyard currentGraveyard = graveyardBuilder.addTombstones(indices).build(this.settings);
        metadataBuilder.indexGraveyard(currentGraveyard);
        logger.trace("{} tombstones purged from the cluster state. Previous tombstone size: {}. Current tombstone size: {}.", (Object)graveyardBuilder.getNumPurged(), (Object)previousGraveyardSize, (Object)currentGraveyard.getTombstones().size());
        Metadata newMetadata = metadataBuilder.build();
        ClusterBlocks blocks = clusterBlocksBuilder.build();
        ImmutableOpenMap<String, ClusterState.Custom> customs = currentState.getCustoms();
        RestoreInProgress restoreInProgress = currentState.custom("restore", RestoreInProgress.EMPTY);
        RestoreInProgress updatedRestoreInProgress = RestoreService.updateRestoreStateWithDeletedIndices(restoreInProgress, indices);
        if (updatedRestoreInProgress != restoreInProgress) {
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(customs);
            builder.put("restore", updatedRestoreInProgress);
            customs = builder.build();
        }
        return this.allocationService.reroute(ClusterState.builder(currentState).routingTable(routingTableBuilder.build()).metadata(newMetadata).blocks(blocks).customs(customs).build(), "deleted indices [" + indices + "]");
    }
}

