/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.easysearch.EasysearchStatusException;
import org.easysearch.ResourceAlreadyExistsException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.easysearch.action.support.ActiveShardCount;
import org.easysearch.action.support.ActiveShardsObserver;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.cluster.AckedClusterStateUpdateTask;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.ack.AckedRequest;
import org.easysearch.cluster.ack.ClusterStateUpdateRequest;
import org.easysearch.cluster.ack.ClusterStateUpdateResponse;
import org.easysearch.cluster.metadata.ComposableIndexTemplate;
import org.easysearch.cluster.metadata.DataStream;
import org.easysearch.cluster.metadata.IndexMetadata;
import org.easysearch.cluster.metadata.Metadata;
import org.easysearch.cluster.metadata.MetadataCreateIndexService;
import org.easysearch.cluster.metadata.MetadataIndexTemplateService;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.Priority;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.common.xcontent.ObjectPath;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.MetadataFieldMapper;
import org.easysearch.rest.RestStatus;
import org.easysearch.threadpool.ThreadPool;

public class MetadataCreateDataStreamService {
    private static final Logger logger = LogManager.getLogger(MetadataCreateDataStreamService.class);
    private final ClusterService clusterService;
    private final ActiveShardsObserver activeShardsObserver;
    private final MetadataCreateIndexService metadataCreateIndexService;

    public MetadataCreateDataStreamService(ThreadPool threadPool, ClusterService clusterService, MetadataCreateIndexService metadataCreateIndexService) {
        this.clusterService = clusterService;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.metadataCreateIndexService = metadataCreateIndexService;
    }

    public void createDataStream(final CreateDataStreamClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> finalListener) {
        final AtomicReference firstBackingIndexRef = new AtomicReference();
        ActionListener<ClusterStateUpdateResponse> listener = ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                String firstBackingIndexName = (String)firstBackingIndexRef.get();
                assert (firstBackingIndexName != null);
                this.activeShardsObserver.waitForActiveShards(new String[]{firstBackingIndexName}, ActiveShardCount.DEFAULT, request.masterNodeTimeout(), shardsAcked -> finalListener.onResponse(new AcknowledgedResponse(true)), finalListener::onFailure);
            } else {
                finalListener.onResponse(new AcknowledgedResponse(false));
            }
        }, finalListener::onFailure);
        this.clusterService.submitStateUpdateTask("create-data-stream [" + request.name + "]", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.HIGH, (AckedRequest)request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState clusterState = MetadataCreateDataStreamService.createDataStream(MetadataCreateDataStreamService.this.metadataCreateIndexService, currentState, request);
                firstBackingIndexRef.set(clusterState.metadata().dataStreams().get(request.name).getIndices().get(0).getName());
                return clusterState;
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }
        });
    }

    public ClusterState createDataStream(CreateDataStreamClusterStateUpdateRequest request, ClusterState current) throws Exception {
        return MetadataCreateDataStreamService.createDataStream(this.metadataCreateIndexService, current, request);
    }

    static ClusterState createDataStream(MetadataCreateIndexService metadataCreateIndexService, ClusterState currentState, CreateDataStreamClusterStateUpdateRequest request) throws Exception {
        if (currentState.metadata().dataStreams().containsKey(request.name)) {
            throw new ResourceAlreadyExistsException("data_stream [" + request.name + "] already exists", new Object[0]);
        }
        MetadataCreateIndexService.validateIndexOrAliasName(request.name, (s1, s2) -> new IllegalArgumentException("data_stream [" + s1 + "] " + s2));
        if (!request.name.toLowerCase(Locale.ROOT).equals(request.name)) {
            throw new IllegalArgumentException("data_stream [" + request.name + "] must be lowercase");
        }
        if (request.name.startsWith(".")) {
            throw new IllegalArgumentException("data_stream [" + request.name + "] must not start with '.'");
        }
        ComposableIndexTemplate template = MetadataCreateDataStreamService.lookupTemplateForDataStream(request.name, currentState.metadata());
        String firstBackingIndexName = DataStream.getDefaultBackingIndexName(request.name, 1L);
        CreateIndexClusterStateUpdateRequest createIndexRequest = new CreateIndexClusterStateUpdateRequest("initialize_data_stream", firstBackingIndexName, firstBackingIndexName).dataStreamName(request.name).settings(Settings.builder().put("index.hidden", true).build());
        try {
            currentState = metadataCreateIndexService.applyCreateIndexRequest(currentState, createIndexRequest, false);
        }
        catch (ResourceAlreadyExistsException e) {
            throw new EasysearchStatusException("data stream could not be created because backing index [{}] already exists", RestStatus.BAD_REQUEST, e, firstBackingIndexName);
        }
        IndexMetadata firstBackingIndex = currentState.metadata().index(firstBackingIndexName);
        assert (firstBackingIndex != null);
        assert (firstBackingIndex.mapping() != null) : "no mapping found for backing index [" + firstBackingIndexName + "]";
        String fieldName = template.getDataStreamTemplate().getTimestampField().getName();
        DataStream.TimestampField timestampField = new DataStream.TimestampField(fieldName);
        DataStream newDataStream = new DataStream(request.name, timestampField, Collections.singletonList(firstBackingIndex.getIndex()));
        Metadata.Builder builder = Metadata.builder(currentState.metadata()).put(newDataStream);
        logger.info("adding data stream [{}]", (Object)request.name);
        return ClusterState.builder(currentState).metadata(builder).build();
    }

    public static ComposableIndexTemplate lookupTemplateForDataStream(String dataStreamName, Metadata metadata) {
        String v2Template = MetadataIndexTemplateService.findV2Template(metadata, dataStreamName, false);
        if (v2Template == null) {
            throw new IllegalArgumentException("no matching index template found for data stream [" + dataStreamName + "]");
        }
        ComposableIndexTemplate composableIndexTemplate = metadata.templatesV2().get(v2Template);
        if (composableIndexTemplate.getDataStreamTemplate() == null) {
            throw new IllegalArgumentException("matching index template [" + v2Template + "] for data stream [" + dataStreamName + "] has no data stream template");
        }
        return composableIndexTemplate;
    }

    public static void validateTimestampFieldMapping(MapperService mapperService) throws IOException {
        MetadataFieldMapper fieldMapper = (MetadataFieldMapper)mapperService.documentMapper().mappers().getMapper("_data_stream_timestamp");
        assert (fieldMapper != null) : "[_data_stream_timestamp] meta field mapper must exist";
        Map<String, Object> parsedTemplateMapping = MapperService.parseMapping(NamedXContentRegistry.EMPTY, mapperService.documentMapper().mappingSource().string());
        Boolean enabled = (Boolean)ObjectPath.eval("_doc._data_stream_timestamp.enabled", parsedTemplateMapping);
        if (enabled == null || !enabled.booleanValue()) {
            throw new IllegalStateException("[_data_stream_timestamp] meta field has been disabled");
        }
        fieldMapper.validate(mapperService.documentMapper().mappers());
    }

    public static final class CreateDataStreamClusterStateUpdateRequest
    extends ClusterStateUpdateRequest {
        private final String name;

        public CreateDataStreamClusterStateUpdateRequest(String name, TimeValue masterNodeTimeout, TimeValue timeout) {
            this.name = name;
            this.masterNodeTimeout(masterNodeTimeout);
            this.ackTimeout(timeout);
        }
    }
}

