/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster;

import org.easysearch.action.ActionListener;
import org.easysearch.cluster.AckedClusterStateTaskListener;
import org.easysearch.cluster.ClusterStateUpdateTask;
import org.easysearch.cluster.ack.AckedRequest;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.Nullable;
import org.easysearch.common.Priority;
import org.easysearch.common.unit.TimeValue;

public abstract class AckedClusterStateUpdateTask<Response>
extends ClusterStateUpdateTask
implements AckedClusterStateTaskListener {
    private final ActionListener<Response> listener;
    private final AckedRequest request;

    protected AckedClusterStateUpdateTask(AckedRequest request, ActionListener<Response> listener) {
        this(Priority.NORMAL, request, listener);
    }

    protected AckedClusterStateUpdateTask(Priority priority, AckedRequest request, ActionListener<Response> listener) {
        super(priority);
        this.listener = listener;
        this.request = request;
    }

    @Override
    public boolean mustAck(DiscoveryNode discoveryNode) {
        return true;
    }

    @Override
    public void onAllNodesAcked(@Nullable Exception e) {
        this.listener.onResponse(this.newResponse(e == null));
    }

    protected abstract Response newResponse(boolean var1);

    @Override
    public void onAckTimeout() {
        this.listener.onResponse(this.newResponse(false));
    }

    @Override
    public void onFailure(String source, Exception e) {
        this.listener.onFailure(e);
    }

    @Override
    public TimeValue ackTimeout() {
        return this.request.ackTimeout();
    }

    @Override
    public TimeValue timeout() {
        return this.request.masterNodeTimeout();
    }
}

