/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.easysearch.client.security.user.Account;
import org.easysearch.common.util.JsonUtils;
import org.easysearch.common.xcontent.XContentParser;

public class GetAccountResponse {
    private final Account account;

    public GetAccountResponse(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    public static GetAccountResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Account account = new Account();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            }
            if (token.isValue()) {
                switch (currentFieldName) {
                    case "username": {
                        account.setUsername(parser.text());
                        break;
                    }
                    case "reserved": {
                        account.setReserved(parser.booleanValue());
                        break;
                    }
                    case "hidden": {
                        account.setHidden(parser.booleanValue());
                        break;
                    }
                    case "builtin": {
                        account.setBuiltin(parser.booleanValue());
                        break;
                    }
                }
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            switch (currentFieldName) {
                case "external_roles": {
                    ArrayList<String> externalRoles = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        externalRoles.add(parser.text());
                    }
                    account.setExternalRoles(externalRoles);
                    break;
                }
                case "roles": {
                    ArrayList<String> roles = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        roles.add(parser.text());
                    }
                    account.setRoles(roles);
                    break;
                }
                case "attributes": {
                    HashSet<String> attributes = new HashSet<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        attributes.add(parser.text());
                    }
                    account.setAttributes(attributes);
                    break;
                }
            }
        }
        return new GetAccountResponse(account);
    }

    public String toJson() {
        return JsonUtils.writeObjectAsString(this.account);
    }
}

