/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.indices;

import java.io.IOException;
import java.util.Map;
import org.easysearch.EasysearchGenerationException;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.client.TimedRequest;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentFactory;
import org.easysearch.common.xcontent.XContentType;

public class PutMappingRequest
extends TimedRequest
implements IndicesRequest,
ToXContentObject {
    private final String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);
    private BytesReference source;
    private XContentType xContentType;

    public PutMappingRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public PutMappingRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    public PutMappingRequest source(Map<String, ?> mappingSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(mappingSource);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new EasysearchGenerationException("Failed to generate [" + mappingSource + "]", e);
        }
    }

    public PutMappingRequest source(String mappingSource, XContentType xContentType) {
        this.source = new BytesArray(mappingSource);
        this.xContentType = xContentType;
        return this;
    }

    public PutMappingRequest source(XContentBuilder builder) {
        this.source = BytesReference.bytes(builder);
        this.xContentType = builder.contentType();
        return this;
    }

    public PutMappingRequest source(BytesReference source, XContentType xContentType) {
        this.source = source;
        this.xContentType = xContentType;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source != null) {
            try (StreamInput stream = this.source.streamInput();){
                builder.rawValue(stream, this.xContentType);
            }
        } else {
            builder.startObject().endObject();
        }
        return builder;
    }
}

