/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.indices;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.easysearch.EasysearchGenerationException;
import org.easysearch.EasysearchParseException;
import org.easysearch.action.admin.indices.alias.Alias;
import org.easysearch.action.support.ActiveShardCount;
import org.easysearch.client.TimedRequest;
import org.easysearch.client.Validatable;
import org.easysearch.common.ParseField;
import org.easysearch.common.Strings;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.xcontent.DeprecationHandler;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentFactory;
import org.easysearch.common.xcontent.XContentHelper;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentType;

public class CreateIndexRequest
extends TimedRequest
implements Validatable,
ToXContentObject {
    static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    static final ParseField ALIASES = new ParseField("aliases", new String[0]);
    private final String index;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private BytesReference mappings;
    private XContentType mappingsXContentType;
    private final Set<Alias> aliases = new HashSet<Alias>();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

    public CreateIndexRequest(String index) {
        if (index == null) {
            throw new IllegalArgumentException("The index name cannot be null.");
        }
        this.index = index;
    }

    public String index() {
        return this.index;
    }

    public Settings settings() {
        return this.settings;
    }

    public CreateIndexRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CreateIndexRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public CreateIndexRequest settings(XContentBuilder builder) {
        this.settings(Strings.toString(builder), builder.contentType());
        return this;
    }

    public CreateIndexRequest settings(Map<String, ?> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public BytesReference mappings() {
        return this.mappings;
    }

    public XContentType mappingsXContentType() {
        return this.mappingsXContentType;
    }

    public CreateIndexRequest mapping(String source, XContentType xContentType) {
        return this.mapping(new BytesArray(source), xContentType);
    }

    public CreateIndexRequest mapping(XContentBuilder source) {
        return this.mapping(BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest mapping(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            return this.mapping(BytesReference.bytes(builder), builder.contentType());
        }
        catch (IOException e) {
            throw new EasysearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest mapping(BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        this.mappings = source;
        this.mappingsXContentType = xContentType;
        return this;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public CreateIndexRequest aliases(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes(builder), builder.contentType());
        }
        catch (IOException e) {
            throw new EasysearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest aliases(String source, XContentType contentType) {
        return this.aliases(new BytesArray(source), contentType);
    }

    public CreateIndexRequest aliases(BytesReference source, XContentType contentType) {
        CreateIndexRequest createIndexRequest;
        block9: {
            XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, source, contentType);
            try {
                parser.nextToken();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    this.alias(Alias.fromXContent(parser));
                }
                createIndexRequest = this;
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EasysearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return createIndexRequest;
    }

    public CreateIndexRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    public CreateIndexRequest aliases(Collection<Alias> aliases) {
        this.aliases.addAll(aliases);
        return this;
    }

    public CreateIndexRequest source(String source, XContentType xContentType) {
        return this.source(new BytesArray(source), xContentType);
    }

    public CreateIndexRequest source(XContentBuilder source) {
        return this.source(BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest source(BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        this.source(XContentHelper.convertToMap(source, false, xContentType).v2());
        return this;
    }

    public CreateIndexRequest source(Map<String, ?> source) {
        DeprecationHandler deprecationHandler = DeprecationHandler.THROW_UNSUPPORTED_OPERATION;
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            String name = entry.getKey();
            if (SETTINGS.match(name, deprecationHandler)) {
                this.settings((Map)entry.getValue());
                continue;
            }
            if (MAPPINGS.match(name, deprecationHandler)) {
                this.mapping((Map)entry.getValue());
                continue;
            }
            if (!ALIASES.match(name, deprecationHandler)) continue;
            this.aliases((Map)entry.getValue());
        }
        return this;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public CreateIndexRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SETTINGS.getPreferredName());
        this.settings.toXContent(builder, params);
        builder.endObject();
        if (this.mappings != null) {
            try (StreamInput stream = this.mappings.streamInput();){
                builder.rawField(MAPPINGS.getPreferredName(), stream, this.mappingsXContentType);
            }
        }
        builder.startObject(ALIASES.getPreferredName());
        for (Alias alias : this.aliases) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

