/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client;

import java.util.function.Supplier;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionRequest;
import org.easysearch.action.ActionResponse;
import org.easysearch.action.ActionType;
import org.easysearch.action.support.ContextPreservingActionListener;
import org.easysearch.client.Client;
import org.easysearch.client.FilterClient;
import org.easysearch.common.util.concurrent.ThreadContext;

public final class OriginSettingClient
extends FilterClient {
    private final String origin;

    public OriginSettingClient(Client in, String origin) {
        super(in);
        this.origin = origin;
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        Supplier<ThreadContext.StoredContext> supplier = this.in().threadPool().getThreadContext().newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = this.in().threadPool().getThreadContext().stashWithOrigin(this.origin);){
            super.doExecute(action, request, new ContextPreservingActionListener<Response>(supplier, listener));
        }
    }
}

