/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.bootstrap;

import java.io.IOException;
import java.nio.file.Path;
import java.security.Permission;
import java.util.Arrays;
import java.util.Locale;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.easysearch.Build;
import org.easysearch.bootstrap.Bootstrap;
import org.easysearch.bootstrap.BootstrapException;
import org.easysearch.bootstrap.Security;
import org.easysearch.bootstrap.StartupException;
import org.easysearch.cli.EnvironmentAwareCommand;
import org.easysearch.cli.Terminal;
import org.easysearch.cli.UserException;
import org.easysearch.common.logging.LogConfigurator;
import org.easysearch.env.Environment;
import org.easysearch.monitor.jvm.JvmInfo;
import org.easysearch.node.NodeValidationException;

class Easysearch
extends EnvironmentAwareCommand {
    private final OptionSpecBuilder versionOption;
    private final OptionSpecBuilder daemonizeOption;
    private final OptionSpec<Path> pidfileOption;
    private final OptionSpecBuilder quietOption;
    private static final boolean isAtLeastJava17 = Runtime.version().feature() >= 17;

    Easysearch() {
        super("Starts Easysearch", () -> {});
        this.versionOption = this.parser.acceptsAll(Arrays.asList("V", "version"), "Prints Easysearch version information and exits");
        this.daemonizeOption = this.parser.acceptsAll(Arrays.asList("d", "daemonize"), "Starts Easysearch in the background").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]);
        this.pidfileOption = this.parser.acceptsAll(Arrays.asList("p", "pidfile"), "Creates a pid file in the specified path on start").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        this.quietOption = this.parser.acceptsAll(Arrays.asList("q", "quiet"), "Turns off standard output/error streams logging in console").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).availableUnless((OptionSpec)this.daemonizeOption, new OptionSpec[0]);
    }

    public static void main(String[] args) throws Exception {
        Easysearch.overrideDnsCachePolicyProperties();
        Easysearch.differentJdkVersionSecurityManagerSettings();
        LogConfigurator.registerErrorListener();
        Easysearch easysearch = new Easysearch();
        int status = Easysearch.main(args, easysearch, Terminal.DEFAULT);
        if (status != 0) {
            String basePath = System.getProperty("es.logs.base_path");
            if (basePath != null) {
                Terminal.DEFAULT.errorPrintln("ERROR: Easysearch did not exit normally - check the logs at " + basePath + System.getProperty("file.separator") + System.getProperty("es.logs.cluster_name") + ".log");
            }
            Easysearch.exit(status);
        }
    }

    private static void differentJdkVersionSecurityManagerSettings() {
        if (isAtLeastJava17) {
            Security.prepopulateSecurityCaller();
            Security.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                }
            });
        } else {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                }
            });
        }
    }

    private static void overrideDnsCachePolicyProperties() {
        for (String property : new String[]{"networkaddress.cache.ttl", "networkaddress.cache.negative.ttl"}) {
            String overrideProperty = "es." + property;
            String overrideValue = System.getProperty(overrideProperty);
            if (overrideValue == null) continue;
            try {
                java.security.Security.setProperty(property, Integer.toString(Integer.valueOf(overrideValue)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse [" + overrideProperty + "] with value [" + overrideValue + "]", e);
            }
        }
    }

    static int main(String[] args, Easysearch easysearch, Terminal terminal) throws Exception {
        return easysearch.main(args, terminal);
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws UserException {
        if (!options.nonOptionArguments().isEmpty()) {
            throw new UserException(64, "Positional arguments not allowed, found " + options.nonOptionArguments());
        }
        if (options.has((OptionSpec)this.versionOption)) {
            String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s/%s, JVM: %s", Build.CURRENT.getQualifiedVersion(), Build.CURRENT.flavor().displayName(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), JvmInfo.jvmInfo().version());
            terminal.println(versionOutput);
            return;
        }
        boolean daemonize = options.has((OptionSpec)this.daemonizeOption);
        Path pidFile = (Path)this.pidfileOption.value(options);
        boolean quiet = options.has((OptionSpec)this.quietOption);
        try {
            env.validateTmpFile();
        }
        catch (IOException e) {
            throw new UserException(78, e.getMessage());
        }
        try {
            this.init(daemonize, pidFile, quiet, env);
        }
        catch (NodeValidationException e) {
            throw new UserException(78, e.getMessage());
        }
    }

    void init(boolean daemonize, Path pidFile, boolean quiet, Environment initialEnv) throws NodeValidationException, UserException {
        try {
            Bootstrap.init(!daemonize, pidFile, quiet, initialEnv);
        }
        catch (RuntimeException | BootstrapException e) {
            throw new StartupException(e);
        }
    }

    static void close(String[] args) throws IOException {
        Bootstrap.stop();
    }
}

