/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.support.tasks;

import java.io.IOException;
import org.easysearch.action.ActionRequest;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.ValidateActions;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.regex.Regex;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.common.util.CollectionUtils;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskId;

public class BaseTasksRequest<Request extends BaseTasksRequest<Request>>
extends ActionRequest {
    public static final String[] ALL_ACTIONS = Strings.EMPTY_ARRAY;
    public static final String[] ALL_NODES = Strings.EMPTY_ARRAY;
    private String[] nodes = ALL_NODES;
    private TimeValue timeout;
    private String[] actions = ALL_ACTIONS;
    private TaskId parentTaskId = TaskId.EMPTY_TASK_ID;
    private TaskId taskId = TaskId.EMPTY_TASK_ID;

    public BaseTasksRequest() {
    }

    protected BaseTasksRequest(StreamInput in) throws IOException {
        super(in);
        this.taskId = TaskId.readFromStream(in);
        this.parentTaskId = TaskId.readFromStream(in);
        this.nodes = in.readStringArray();
        this.actions = in.readStringArray();
        this.timeout = in.readOptionalTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.taskId.writeTo(out);
        this.parentTaskId.writeTo(out);
        out.writeStringArrayNullable(this.nodes);
        out.writeStringArrayNullable(this.actions);
        out.writeOptionalTimeValue(this.timeout);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.taskId.isSet() && this.nodes.length > 0) {
            validationException = ValidateActions.addValidationError("task id cannot be used together with node ids", validationException);
        }
        return validationException;
    }

    public final Request setActions(String ... actions) {
        this.actions = actions;
        return (Request)this;
    }

    public String[] getActions() {
        return this.actions;
    }

    public final String[] getNodes() {
        return this.nodes;
    }

    public final Request setNodes(String ... nodes) {
        this.nodes = nodes;
        return (Request)this;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public final Request setTaskId(TaskId taskId) {
        this.taskId = taskId;
        return (Request)this;
    }

    public TaskId getParentTaskId() {
        return this.parentTaskId;
    }

    public Request setParentTaskId(TaskId parentTaskId) {
        this.parentTaskId = parentTaskId;
        return (Request)this;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public final Request setTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final Request setTimeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".timeout");
        return (Request)this;
    }

    public boolean match(Task task) {
        if (!CollectionUtils.isEmpty(this.getActions()) && !Regex.simpleMatch(this.getActions(), task.getAction())) {
            return false;
        }
        if (this.getTaskId().isSet() && this.getTaskId().getId() != task.getId()) {
            return false;
        }
        return !this.parentTaskId.isSet() || this.parentTaskId.equals(task.getParentTaskId());
    }
}

