/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.support.single.shard;

import java.io.IOException;
import org.easysearch.action.ActionRequest;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.ValidateActions;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.common.Nullable;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.index.shard.ShardId;

public abstract class SingleShardRequest<Request extends SingleShardRequest<Request>>
extends ActionRequest
implements IndicesRequest {
    public static final IndicesOptions INDICES_OPTIONS = IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    @Nullable
    protected String index;
    ShardId internalShardId;

    public SingleShardRequest() {
    }

    public SingleShardRequest(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.internalShardId = new ShardId(in);
        }
        this.index = in.readOptionalString();
    }

    protected SingleShardRequest(String index) {
        this.index = index;
    }

    protected ActionRequestValidationException validateNonNullIndex() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    public final Request index(String index) {
        this.index = index;
        return (Request)this;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return INDICES_OPTIONS;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.internalShardId);
        out.writeOptionalString(this.index);
    }
}

