/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.support;

import java.util.concurrent.TimeUnit;
import org.easysearch.EasysearchException;
import org.easysearch.action.ActionFuture;
import org.easysearch.action.ActionListener;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.common.util.concurrent.BaseFuture;
import org.easysearch.common.util.concurrent.FutureUtils;
import org.easysearch.common.util.concurrent.UncategorizedExecutionException;

public abstract class AdapterActionFuture<T, L>
extends BaseFuture<T>
implements ActionFuture<T>,
ActionListener<L> {
    @Override
    public T actionGet() {
        try {
            return FutureUtils.get(this);
        }
        catch (EasysearchException e) {
            throw AdapterActionFuture.unwrapEsException(e);
        }
    }

    @Override
    public T actionGet(String timeout) {
        return this.actionGet(TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".actionGet.timeout"));
    }

    @Override
    public T actionGet(long timeoutMillis) {
        return this.actionGet(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(TimeValue timeout) {
        return this.actionGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(long timeout, TimeUnit unit) {
        try {
            return FutureUtils.get(this, timeout, unit);
        }
        catch (EasysearchException e) {
            throw AdapterActionFuture.unwrapEsException(e);
        }
    }

    @Override
    public void onResponse(L result) {
        this.set(this.convert(result));
    }

    @Override
    public void onFailure(Exception e) {
        this.setException(e);
    }

    protected abstract T convert(L var1);

    private static RuntimeException unwrapEsException(EasysearchException esEx) {
        Throwable root = esEx.unwrapCause();
        if (root instanceof RuntimeException) {
            return (RuntimeException)root;
        }
        return new UncategorizedExecutionException("Failed execution", root);
    }
}

