/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.RAMOutputStream;
import org.easysearch.Version;
import org.easysearch.action.search.ParsedScrollId;
import org.easysearch.action.search.SearchContextIdForNode;
import org.easysearch.action.search.SearchScrollRequest;
import org.easysearch.common.util.concurrent.AtomicArray;
import org.easysearch.search.SearchPhaseResult;
import org.easysearch.search.SearchShardTarget;
import org.easysearch.search.internal.InternalScrollSearchRequest;
import org.easysearch.search.internal.ShardSearchContextId;
import org.easysearch.transport.RemoteClusterAware;

final class TransportSearchHelper {
    private static final String INCLUDE_CONTEXT_UUID = "include_context_uuid";

    static InternalScrollSearchRequest internalScrollSearchRequest(ShardSearchContextId id, SearchScrollRequest request) {
        return new InternalScrollSearchRequest(request, id);
    }

    static String buildScrollId(AtomicArray<? extends SearchPhaseResult> searchPhaseResults, Version version) {
        String throwable2;
        boolean includeContextUUID = true;
        RAMOutputStream out = new RAMOutputStream();
        try {
            if (includeContextUUID) {
                out.writeString(INCLUDE_CONTEXT_UUID);
            }
            out.writeString(searchPhaseResults.length() == 1 ? "queryAndFetch" : "queryThenFetch");
            out.writeVInt(searchPhaseResults.asList().size());
            for (SearchPhaseResult string : searchPhaseResults.asList()) {
                if (includeContextUUID) {
                    out.writeString(string.getContextId().getSessionId());
                }
                out.writeLong(string.getContextId().getId());
                SearchShardTarget searchShardTarget = string.getSearchShardTarget();
                if (searchShardTarget.getClusterAlias() != null) {
                    out.writeString(RemoteClusterAware.buildRemoteIndexName(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId()));
                    continue;
                }
                out.writeString(searchShardTarget.getNodeId());
            }
            byte[] bytes = new byte[(int)out.getFilePointer()];
            out.writeTo(bytes, 0);
            throwable2 = Base64.getUrlEncoder().encodeToString(bytes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        out.close();
        return throwable2;
    }

    static ParsedScrollId parseScrollId(String scrollId) {
        try {
            String type;
            boolean includeContextUUID;
            byte[] bytes = Base64.getUrlDecoder().decode(scrollId);
            ByteArrayDataInput in = new ByteArrayDataInput(bytes);
            String firstChunk = in.readString();
            if (INCLUDE_CONTEXT_UUID.equals(firstChunk)) {
                includeContextUUID = true;
                type = in.readString();
            } else {
                includeContextUUID = false;
                type = firstChunk;
            }
            SearchContextIdForNode[] context = new SearchContextIdForNode[in.readVInt()];
            for (int i = 0; i < context.length; ++i) {
                String clusterAlias;
                String contextUUID = includeContextUUID ? in.readString() : "";
                long id = in.readLong();
                String target = in.readString();
                int index = target.indexOf(58);
                if (index == -1) {
                    clusterAlias = null;
                } else {
                    clusterAlias = target.substring(0, index);
                    target = target.substring(index + 1);
                }
                context[i] = new SearchContextIdForNode(clusterAlias, target, new ShardSearchContextId(contextUUID, id));
            }
            if (in.getPosition() != bytes.length) {
                throw new IllegalArgumentException("Not all bytes were read");
            }
            return new ParsedScrollId(scrollId, type, context);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse scroll id", e);
        }
    }

    private TransportSearchHelper() {
    }
}

