/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.search;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import org.easysearch.action.ActionListener;
import org.easysearch.action.search.MultiSearchRequest;
import org.easysearch.action.search.MultiSearchResponse;
import org.easysearch.action.search.SearchRequest;
import org.easysearch.action.search.SearchResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.HandledTransportAction;
import org.easysearch.client.node.NodeClient;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.util.concurrent.AtomicArray;
import org.easysearch.common.util.concurrent.EsExecutors;
import org.easysearch.tasks.Task;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportMultiSearchAction
extends HandledTransportAction<MultiSearchRequest, MultiSearchResponse> {
    private final int allocatedProcessors;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final LongSupplier relativeTimeProvider;
    private final NodeClient client;

    @Inject
    public TransportMultiSearchAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, NodeClient client) {
        super("indices:data/read/msearch", transportService, actionFilters, MultiSearchRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.allocatedProcessors = EsExecutors.allocatedProcessors(settings);
        this.relativeTimeProvider = System::nanoTime;
        this.client = client;
    }

    TransportMultiSearchAction(ThreadPool threadPool, ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, int allocatedProcessors, LongSupplier relativeTimeProvider, NodeClient client) {
        super("indices:data/read/msearch", transportService, actionFilters, MultiSearchRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.allocatedProcessors = allocatedProcessors;
        this.relativeTimeProvider = relativeTimeProvider;
        this.client = client;
    }

    @Override
    protected void doExecute(Task task, MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        long relativeStartTime = this.relativeTimeProvider.getAsLong();
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        int maxConcurrentSearches = request.maxConcurrentSearchRequests();
        if (maxConcurrentSearches == 0) {
            maxConcurrentSearches = TransportMultiSearchAction.defaultMaxConcurrentSearches(this.allocatedProcessors, clusterState);
        }
        ConcurrentLinkedQueue<SearchRequestSlot> searchRequestSlots = new ConcurrentLinkedQueue<SearchRequestSlot>();
        for (int i = 0; i < request.requests().size(); ++i) {
            SearchRequest searchRequest = request.requests().get(i);
            searchRequest.setParentTask(this.client.getLocalNodeId(), task.getId());
            searchRequestSlots.add(new SearchRequestSlot(searchRequest, i));
        }
        int numRequests = request.requests().size();
        AtomicArray<MultiSearchResponse.Item> responses = new AtomicArray<MultiSearchResponse.Item>(numRequests);
        AtomicInteger responseCounter = new AtomicInteger(numRequests);
        int numConcurrentSearches = Math.min(numRequests, maxConcurrentSearches);
        for (int i = 0; i < numConcurrentSearches; ++i) {
            this.executeSearch(searchRequestSlots, responses, responseCounter, listener, relativeStartTime);
        }
    }

    static int defaultMaxConcurrentSearches(int allocatedProcessors, ClusterState state) {
        int numDateNodes = state.getNodes().getDataNodes().size();
        int defaultSearchThreadPoolSize = Math.min(ThreadPool.searchThreadPoolSize(allocatedProcessors), 10);
        return Math.max(1, numDateNodes * defaultSearchThreadPoolSize);
    }

    void executeSearch(final Queue<SearchRequestSlot> requests, final AtomicArray<MultiSearchResponse.Item> responses, final AtomicInteger responseCounter, final ActionListener<MultiSearchResponse> listener, final long relativeStartTime) {
        final SearchRequestSlot request = requests.poll();
        if (request == null) {
            return;
        }
        final Thread thread = Thread.currentThread();
        this.client.search(request.request, new ActionListener<SearchResponse>(){

            @Override
            public void onResponse(SearchResponse searchResponse) {
                this.handleResponse(request.responseSlot, new MultiSearchResponse.Item(searchResponse, null));
            }

            @Override
            public void onFailure(Exception e) {
                this.handleResponse(request.responseSlot, new MultiSearchResponse.Item(null, e));
            }

            private void handleResponse(int responseSlot, MultiSearchResponse.Item item) {
                responses.set(responseSlot, item);
                if (responseCounter.decrementAndGet() == 0) {
                    assert (requests.isEmpty());
                    this.finish();
                } else if (thread == Thread.currentThread()) {
                    TransportMultiSearchAction.this.threadPool.generic().execute(() -> TransportMultiSearchAction.this.executeSearch(requests, responses, responseCounter, listener, relativeStartTime));
                } else {
                    TransportMultiSearchAction.this.executeSearch(requests, responses, responseCounter, listener, relativeStartTime);
                }
            }

            private void finish() {
                listener.onResponse(new MultiSearchResponse(responses.toArray(new MultiSearchResponse.Item[responses.length()]), this.buildTookInMillis()));
            }

            private long buildTookInMillis() {
                return TimeUnit.NANOSECONDS.toMillis(TransportMultiSearchAction.this.relativeTimeProvider.getAsLong() - relativeStartTime);
            }
        });
    }

    static final class SearchRequestSlot {
        final SearchRequest request;
        final int responseSlot;

        SearchRequestSlot(SearchRequest request, int responseSlot) {
            this.request = request;
            this.responseSlot = responseSlot;
        }
    }
}

