/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.get;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.easysearch.action.ActionListener;
import org.easysearch.action.get.GetResponse;
import org.easysearch.action.get.MultiGetRequest;
import org.easysearch.action.get.MultiGetResponse;
import org.easysearch.action.get.MultiGetShardRequest;
import org.easysearch.action.get.MultiGetShardResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.TransportActions;
import org.easysearch.action.support.single.shard.TransportSingleShardAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.routing.ShardIterator;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.index.IndexService;
import org.easysearch.index.get.GetResult;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.index.shard.ShardId;
import org.easysearch.indices.IndicesService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportShardMultiGetAction
extends TransportSingleShardAction<MultiGetShardRequest, MultiGetShardResponse> {
    private static final String ACTION_NAME = "indices:data/read/mget[shard]";
    private final IndicesService indicesService;

    @Inject
    public TransportShardMultiGetAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, MultiGetShardRequest::new, "get");
        this.indicesService = indicesService;
    }

    @Override
    protected boolean isSubAction() {
        return true;
    }

    @Override
    protected Writeable.Reader<MultiGetShardResponse> getResponseReader() {
        return MultiGetShardResponse::new;
    }

    @Override
    protected boolean resolveIndex(MultiGetShardRequest request) {
        return true;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(state, ((MultiGetShardRequest)request.request()).index(), ((MultiGetShardRequest)request.request()).shardId(), ((MultiGetShardRequest)request.request()).preference());
    }

    @Override
    protected void asyncShardOperation(MultiGetShardRequest request, ShardId shardId, ActionListener<MultiGetShardResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.realtime()) {
            super.asyncShardOperation(request, shardId, listener);
        } else {
            indexShard.awaitShardSearchActive(b -> {
                try {
                    super.asyncShardOperation(request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    @Override
    protected MultiGetShardResponse shardOperation(MultiGetShardRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.refresh() && !request.realtime()) {
            indexShard.refresh("refresh_flag_mget");
        }
        MultiGetShardResponse response = new MultiGetShardResponse();
        for (int i = 0; i < request.locations.size(); ++i) {
            MultiGetRequest.Item item = request.items.get(i);
            try {
                GetResult getResult = indexShard.getService().get(item.type(), item.id(), item.storedFields(), request.realtime(), item.version(), item.versionType(), item.fetchSourceContext());
                response.add(request.locations.get(i), new GetResponse(getResult));
                continue;
            }
            catch (RuntimeException e) {
                if (TransportActions.isShardNotAvailableException(e)) {
                    throw e;
                }
                this.logger.debug(() -> new ParameterizedMessage("{} failed to execute multi_get for [{}]/[{}]", new Object[]{shardId, item.type(), item.id()}), (Throwable)e);
                response.add(request.locations.get(i), new MultiGetResponse.Failure(request.index(), item.type(), item.id(), e));
            }
        }
        return response;
    }

    @Override
    protected String getExecutor(MultiGetShardRequest request, ShardId shardId) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState.metadata().index(shardId.getIndex()).isSystem()) {
            return "system_read";
        }
        if (this.indicesService.indexServiceSafe(shardId.getIndex()).getIndexSettings().isSearchThrottled()) {
            return "search_throttled";
        }
        return super.getExecutor(request, shardId);
    }
}

