/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.bulk;

import java.io.IOException;
import java.util.HashSet;
import java.util.stream.Stream;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.easysearch.CompatibleESVersion;
import org.easysearch.Version;
import org.easysearch.action.bulk.BulkItemRequest;
import org.easysearch.action.support.WriteRequest;
import org.easysearch.action.support.replication.ReplicatedWriteRequest;
import org.easysearch.action.support.replication.ReplicationRequest;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.index.shard.ShardId;

public class BulkShardRequest
extends ReplicatedWriteRequest<BulkShardRequest>
implements Accountable {
    public static final Version COMPACT_SHARD_ID_VERSION = CompatibleESVersion.V_7_10_2;
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(BulkShardRequest.class);
    private final BulkItemRequest[] items;

    public BulkShardRequest(StreamInput in) throws IOException {
        super(in);
        ShardId itemShardId = in.getVersion().onOrAfter(COMPACT_SHARD_ID_VERSION) ? this.shardId : null;
        this.items = in.readArray(i -> i.readOptionalWriteable(inpt -> new BulkItemRequest(itemShardId, inpt)), BulkItemRequest[]::new);
    }

    public BulkShardRequest(ShardId shardId, WriteRequest.RefreshPolicy refreshPolicy, BulkItemRequest[] items) {
        super(shardId);
        this.items = items;
        this.setRefreshPolicy(refreshPolicy);
    }

    public BulkItemRequest[] items() {
        return this.items;
    }

    @Override
    public String[] indices() {
        HashSet<String> indices = new HashSet<String>(1);
        for (BulkItemRequest item : this.items) {
            if (item == null) continue;
            indices.add(item.index());
        }
        return indices.toArray(new String[0]);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray(out.getVersion().onOrAfter(COMPACT_SHARD_ID_VERSION) ? (o, item) -> {
            if (item != null) {
                o.writeBoolean(true);
                item.writeThin(o);
            } else {
                o.writeBoolean(false);
            }
        } : StreamOutput::writeOptionalWriteable, this.items);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("BulkShardRequest [");
        b.append(this.shardId).append("] containing [");
        if (this.items.length > 1) {
            b.append(this.items.length).append("] requests");
        } else {
            b.append(this.items[0].request()).append("]");
        }
        switch (this.getRefreshPolicy()) {
            case IMMEDIATE: {
                b.append(" and a refresh");
                break;
            }
            case WAIT_UNTIL: {
                b.append(" blocking until refresh");
                break;
            }
        }
        return b.toString();
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder().append("requests[").append(this.items.length).append("], index").append(this.shardId);
        WriteRequest.RefreshPolicy refreshPolicy = this.getRefreshPolicy();
        if (refreshPolicy == WriteRequest.RefreshPolicy.IMMEDIATE || refreshPolicy == WriteRequest.RefreshPolicy.WAIT_UNTIL) {
            stringBuilder.append(", refresh[").append(refreshPolicy).append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    protected BulkShardRequest routedBasedOnClusterVersion(long routedBasedOnClusterVersion) {
        return (BulkShardRequest)super.routedBasedOnClusterVersion(routedBasedOnClusterVersion);
    }

    @Override
    public void onRetry() {
        for (BulkItemRequest item : this.items) {
            if (!(item.request() instanceof ReplicationRequest)) continue;
            ((ReplicationRequest)((Object)item.request())).onRetry();
        }
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + Stream.of(this.items).mapToLong(Accountable::ramBytesUsed).sum();
    }
}

