/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.template.put;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.action.support.master.TransportMasterNodeAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.metadata.MetadataIndexTemplateService;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.settings.IndexScopedSettings;
import org.easysearch.common.settings.Settings;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportPutIndexTemplateAction
extends TransportMasterNodeAction<PutIndexTemplateRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutIndexTemplateAction.class);
    private final MetadataIndexTemplateService indexTemplateService;
    private final IndexScopedSettings indexScopedSettings;

    @Inject
    public TransportPutIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexScopedSettings indexScopedSettings) {
        super("indices:admin/template/put", transportService, clusterService, threadPool, actionFilters, PutIndexTemplateRequest::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(PutIndexTemplateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(final PutIndexTemplateRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        String cause = request.cause();
        if (cause.length() == 0) {
            cause = "api";
        }
        Settings.Builder templateSettingsBuilder = Settings.builder();
        templateSettingsBuilder.put(request.settings()).normalizePrefix("index.");
        this.indexScopedSettings.validate(templateSettingsBuilder.build(), true);
        this.indexTemplateService.putTemplate(new MetadataIndexTemplateService.PutRequest(cause, request.name()).patterns(request.patterns()).order(request.order()).settings(templateSettingsBuilder.build()).mappings(request.mappings()).aliases(request.aliases()).create(request.create()).masterTimeout(request.masterNodeTimeout()).version(request.version()), new MetadataIndexTemplateService.PutListener(){

            @Override
            public void onResponse(MetadataIndexTemplateService.PutResponse response) {
                listener.onResponse(new AcknowledgedResponse(response.acknowledged()));
            }

            @Override
            public void onFailure(Exception e) {
                logger.debug(() -> new ParameterizedMessage("failed to put template [{}]", (Object)request.name()), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }
}

