/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.template.get;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.easysearch.ResourceNotFoundException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.template.get.GetComposableIndexTemplateAction;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.TransportMasterNodeReadAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.ComposableIndexTemplate;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.regex.Regex;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportGetComposableIndexTemplateAction
extends TransportMasterNodeReadAction<GetComposableIndexTemplateAction.Request, GetComposableIndexTemplateAction.Response> {
    @Inject
    public TransportGetComposableIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/index_template/get", transportService, clusterService, threadPool, actionFilters, GetComposableIndexTemplateAction.Request::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected GetComposableIndexTemplateAction.Response read(StreamInput in) throws IOException {
        return new GetComposableIndexTemplateAction.Response(in);
    }

    @Override
    protected ClusterBlockException checkBlock(GetComposableIndexTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetComposableIndexTemplateAction.Request request, ClusterState state, ActionListener<GetComposableIndexTemplateAction.Response> listener) {
        Map<String, ComposableIndexTemplate> allTemplates = state.metadata().templatesV2();
        if (request.name() == null) {
            listener.onResponse(new GetComposableIndexTemplateAction.Response(allTemplates));
            return;
        }
        HashMap<String, ComposableIndexTemplate> results = new HashMap<String, ComposableIndexTemplate>();
        String name = request.name();
        if (Regex.isSimpleMatchPattern(name)) {
            for (Map.Entry<String, ComposableIndexTemplate> entry : allTemplates.entrySet()) {
                if (!Regex.simpleMatch(name, entry.getKey())) continue;
                results.put(entry.getKey(), entry.getValue());
            }
        } else if (allTemplates.containsKey(name)) {
            results.put(name, allTemplates.get(name));
        } else {
            throw new ResourceNotFoundException("index template matching [" + request.name() + "] not found", new Object[0]);
        }
        listener.onResponse(new GetComposableIndexTemplateAction.Response(results));
    }
}

