/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.easysearch.action.admin.indices.stats.FieldUsageShardResponse;
import org.easysearch.action.support.DefaultShardOperationFailedException;
import org.easysearch.action.support.broadcast.BroadcastResponse;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;

public class FieldUsageTrackerResponse
extends BroadcastResponse {
    private final Map<String, List<FieldUsageShardResponse>> stats;

    FieldUsageTrackerResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, Map<String, List<FieldUsageShardResponse>> stats) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.stats = stats;
    }

    FieldUsageTrackerResponse(StreamInput in) throws IOException {
        super(in);
        this.stats = in.readMap(StreamInput::readString, i -> i.readList(FieldUsageShardResponse::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.stats, StreamOutput::writeString, StreamOutput::writeList);
    }

    public Map<String, List<FieldUsageShardResponse>> getStats() {
        return this.stats;
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        List sortedEntries = this.stats.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        for (Map.Entry entry : sortedEntries) {
            builder.startObject((String)entry.getKey());
            builder.startArray("shards");
            for (FieldUsageShardResponse resp : (List)entry.getValue()) {
                resp.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
        }
    }
}

