/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.mapping.put;

import java.io.IOException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.easysearch.action.admin.indices.mapping.put.TransportPutMappingAction;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.action.support.master.TransportMasterNodeAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.metadata.MetadataMappingService;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.Index;
import org.easysearch.tasks.Task;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportAutoPutMappingAction
extends TransportMasterNodeAction<PutMappingRequest, AcknowledgedResponse> {
    private final MetadataMappingService metadataMappingService;

    @Inject
    public TransportAutoPutMappingAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataMappingService metadataMappingService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/mapping/auto_put", transportService, clusterService, threadPool, actionFilters, PutMappingRequest::new, indexNameExpressionResolver);
        this.metadataMappingService = metadataMappingService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void doExecute(Task task, PutMappingRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (request.getConcreteIndex() == null) {
            throw new IllegalArgumentException("concrete index missing");
        }
        super.doExecute(task, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices = new String[]{request.getConcreteIndex().getName()};
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected void masterOperation(PutMappingRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        Index[] concreteIndices = new Index[]{request.getConcreteIndex()};
        TransportPutMappingAction.performMappingUpdate(concreteIndices, request, listener, this.metadataMappingService);
    }
}

