/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.exists.types;

import java.io.IOException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.exists.types.TypesExistsRequest;
import org.easysearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.TransportMasterNodeReadAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.metadata.MappingMetadata;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportTypesExistsAction
extends TransportMasterNodeReadAction<TypesExistsRequest, TypesExistsResponse> {
    @Inject
    public TransportTypesExistsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/types/exists", transportService, clusterService, threadPool, actionFilters, TypesExistsRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected TypesExistsResponse read(StreamInput in) throws IOException {
        return new TypesExistsResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(TypesExistsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void masterOperation(TypesExistsRequest request, ClusterState state, ActionListener<TypesExistsResponse> listener) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, request.indicesOptions(), request.indices());
        if (concreteIndices.length == 0) {
            listener.onResponse(new TypesExistsResponse(false));
            return;
        }
        for (String concreteIndex : concreteIndices) {
            if (!state.metadata().hasConcreteIndex(concreteIndex)) {
                listener.onResponse(new TypesExistsResponse(false));
                return;
            }
            MappingMetadata mapping = state.metadata().getIndices().get(concreteIndex).mapping();
            if (mapping == null) {
                listener.onResponse(new TypesExistsResponse(false));
                return;
            }
            for (String type : request.types()) {
                if (mapping.type().equals(type)) continue;
                listener.onResponse(new TypesExistsResponse(false));
                return;
            }
        }
        listener.onResponse(new TypesExistsResponse(true));
    }
}

