/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.dangling.import_index;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.support.master.AcknowledgedRequest;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;

public class ImportDanglingIndexRequest
extends AcknowledgedRequest<ImportDanglingIndexRequest> {
    private final String indexUUID;
    private final boolean acceptDataLoss;

    public ImportDanglingIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.indexUUID = in.readString();
        this.acceptDataLoss = in.readBoolean();
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public ImportDanglingIndexRequest(String indexUUID, boolean acceptDataLoss) {
        this.indexUUID = Objects.requireNonNull(indexUUID, "indexUUID cannot be null");
        this.acceptDataLoss = acceptDataLoss;
    }

    public String getIndexUUID() {
        return this.indexUUID;
    }

    public boolean isAcceptDataLoss() {
        return this.acceptDataLoss;
    }

    public String toString() {
        return String.format(Locale.ROOT, "ImportDanglingIndexRequest{indexUUID='%s', acceptDataLoss=%s}", this.indexUUID, this.acceptDataLoss);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.indexUUID);
        out.writeBoolean(this.acceptDataLoss);
    }
}

