/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.reroute;

import java.io.IOException;
import java.util.Objects;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.support.master.AcknowledgedRequest;
import org.easysearch.cluster.routing.allocation.command.AllocationCommand;
import org.easysearch.cluster.routing.allocation.command.AllocationCommands;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;

public class ClusterRerouteRequest
extends AcknowledgedRequest<ClusterRerouteRequest> {
    private AllocationCommands commands = new AllocationCommands(new AllocationCommand[0]);
    private boolean dryRun;
    private boolean explain;
    private boolean retryFailed;

    public ClusterRerouteRequest(StreamInput in) throws IOException {
        super(in);
        this.commands = AllocationCommands.readFrom(in);
        this.dryRun = in.readBoolean();
        this.explain = in.readBoolean();
        this.retryFailed = in.readBoolean();
    }

    public ClusterRerouteRequest() {
    }

    public ClusterRerouteRequest add(AllocationCommand ... commands) {
        this.commands.add(commands);
        return this;
    }

    public ClusterRerouteRequest dryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public boolean dryRun() {
        return this.dryRun;
    }

    public ClusterRerouteRequest explain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public ClusterRerouteRequest setRetryFailed(boolean retryFailed) {
        this.retryFailed = retryFailed;
        return this;
    }

    public boolean explain() {
        return this.explain;
    }

    public boolean isRetryFailed() {
        return this.retryFailed;
    }

    public ClusterRerouteRequest commands(AllocationCommands commands) {
        this.commands = commands;
        return this;
    }

    public AllocationCommands getCommands() {
        return this.commands;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        AllocationCommands.writeTo(this.commands, out);
        out.writeBoolean(this.dryRun);
        out.writeBoolean(this.explain);
        out.writeBoolean(this.retryFailed);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterRerouteRequest other = (ClusterRerouteRequest)obj;
        return Objects.equals(this.commands, other.commands) && Objects.equals(this.dryRun, other.dryRun) && Objects.equals(this.explain, other.explain) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.retryFailed, other.retryFailed) && Objects.equals(this.masterNodeTimeout, other.masterNodeTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.commands, this.dryRun, this.explain, this.timeout, this.retryFailed, this.masterNodeTimeout);
    }
}

