/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.repositories.get;

import java.io.IOException;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.ValidateActions;
import org.easysearch.action.support.master.MasterNodeReadRequest;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;

public class GetRepositoriesRequest
extends MasterNodeReadRequest<GetRepositoriesRequest> {
    private String[] repositories = Strings.EMPTY_ARRAY;

    public GetRepositoriesRequest() {
    }

    public GetRepositoriesRequest(String[] repositories) {
        this.repositories = repositories;
    }

    public GetRepositoriesRequest(StreamInput in) throws IOException {
        super(in);
        this.repositories = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.repositories);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repositories == null) {
            validationException = ValidateActions.addValidationError("repositories is null", validationException);
        }
        return validationException;
    }

    public String[] repositories() {
        return this.repositories;
    }

    public GetRepositoriesRequest repositories(String[] repositories) {
        this.repositories = repositories;
        return this;
    }
}

