/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.node.reload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.easysearch.EasysearchException;
import org.easysearch.ExceptionsHelper;
import org.easysearch.action.ActionListener;
import org.easysearch.action.FailedNodeException;
import org.easysearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import org.easysearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.nodes.BaseNodeRequest;
import org.easysearch.action.support.nodes.TransportNodesAction;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.settings.KeyStoreWrapper;
import org.easysearch.common.settings.SecureString;
import org.easysearch.common.settings.Settings;
import org.easysearch.env.Environment;
import org.easysearch.plugins.PluginsService;
import org.easysearch.plugins.ReloadablePlugin;
import org.easysearch.tasks.Task;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportNodesReloadSecureSettingsAction
extends TransportNodesAction<NodesReloadSecureSettingsRequest, NodesReloadSecureSettingsResponse, NodeRequest, NodesReloadSecureSettingsResponse.NodeResponse> {
    private final Environment environment;
    private final PluginsService pluginsService;

    @Inject
    public TransportNodesReloadSecureSettingsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Environment environment, PluginsService pluginService) {
        super("cluster:admin/nodes/reload_secure_settings", threadPool, clusterService, transportService, actionFilters, NodesReloadSecureSettingsRequest::new, NodeRequest::new, "generic", NodesReloadSecureSettingsResponse.NodeResponse.class);
        this.environment = environment;
        this.pluginsService = pluginService;
    }

    @Override
    protected NodesReloadSecureSettingsResponse newResponse(NodesReloadSecureSettingsRequest request, List<NodesReloadSecureSettingsResponse.NodeResponse> responses, List<FailedNodeException> failures) {
        return new NodesReloadSecureSettingsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeRequest newNodeRequest(NodesReloadSecureSettingsRequest request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodesReloadSecureSettingsResponse.NodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new NodesReloadSecureSettingsResponse.NodeResponse(in);
    }

    @Override
    protected void doExecute(Task task, NodesReloadSecureSettingsRequest request, ActionListener<NodesReloadSecureSettingsResponse> listener) {
        if (request.hasPassword() && !this.isNodeLocal(request) && !this.isNodeTransportTLSEnabled()) {
            request.closePassword();
            listener.onFailure(new EasysearchException("Secure settings cannot be updated cluster wide when TLS for the transport layer is not enabled. Enable TLS or use the API with a `_local` filter on each node.", new Object[0]));
        } else {
            super.doExecute(task, request, ActionListener.wrap(response -> {
                request.closePassword();
                listener.onResponse((NodesReloadSecureSettingsResponse)response);
            }, e -> {
                request.closePassword();
                listener.onFailure((Exception)e);
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NodesReloadSecureSettingsResponse.NodeResponse nodeOperation(NodeRequest nodeReloadRequest) {
        NodesReloadSecureSettingsRequest request = nodeReloadRequest.request;
        try (SecureString secureSettingsPassword = request.hasPassword() ? request.getSecureSettingsPassword() : new SecureString(new char[0]);){
            KeyStoreWrapper keystore;
            block15: {
                keystore = KeyStoreWrapper.load(this.environment.configFile());
                try {
                    if (keystore != null) break block15;
                    NodesReloadSecureSettingsResponse.NodeResponse nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), new IllegalStateException("Keystore is missing"));
                    if (keystore != null) {
                        keystore.close();
                    }
                    return nodeResponse;
                }
                catch (Throwable throwable) {
                    try {
                        if (keystore != null) {
                            try {
                                keystore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        NodesReloadSecureSettingsResponse.NodeResponse nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), e);
                        return nodeResponse;
                    }
                }
            }
            keystore.decrypt(secureSettingsPassword.getChars());
            Settings settingsWithKeystore = Settings.builder().put(this.environment.settings(), false).setSecureSettings(keystore).build();
            ArrayList exceptions = new ArrayList();
            this.pluginsService.filterPlugins(ReloadablePlugin.class).stream().forEach(p -> {
                try {
                    p.reload(settingsWithKeystore);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("Reload failed for plugin [{}]", (Object)p.getClass().getSimpleName()), (Throwable)e);
                    exceptions.add(e);
                }
            });
            ExceptionsHelper.rethrowAndSuppress(exceptions);
            NodesReloadSecureSettingsResponse.NodeResponse nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), null);
            if (keystore != null) {
                keystore.close();
            }
            return nodeResponse;
        }
    }

    private boolean isNodeTransportTLSEnabled() {
        return this.transportService.isTransportSecure();
    }

    private boolean isNodeLocal(NodesReloadSecureSettingsRequest request) {
        DiscoveryNode[] nodes;
        if (null == request.concreteNodes()) {
            this.resolveRequest(request, this.clusterService.state());
            assert (request.concreteNodes() != null);
        }
        return (nodes = request.concreteNodes()).length == 1 && nodes[0].getId().equals(this.clusterService.localNode().getId());
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        NodesReloadSecureSettingsRequest request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesReloadSecureSettingsRequest(in);
        }

        NodeRequest(NodesReloadSecureSettingsRequest request) {
            this.request = request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

