/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.cluster.allocation.ClusterAllocationExplainRequest;
import org.easysearch.action.admin.cluster.allocation.ClusterAllocationExplainResponse;
import org.easysearch.action.admin.cluster.allocation.ClusterAllocationExplanation;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.TransportMasterNodeAction;
import org.easysearch.cluster.ClusterInfo;
import org.easysearch.cluster.ClusterInfoService;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.cluster.routing.RoutingNodes;
import org.easysearch.cluster.routing.ShardRouting;
import org.easysearch.cluster.routing.allocation.AllocationService;
import org.easysearch.cluster.routing.allocation.RoutingAllocation;
import org.easysearch.cluster.routing.allocation.ShardAllocationDecision;
import org.easysearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.easysearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.snapshots.SnapshotsInfoService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportClusterAllocationExplainAction
extends TransportMasterNodeAction<ClusterAllocationExplainRequest, ClusterAllocationExplainResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterAllocationExplainAction.class);
    private final ClusterInfoService clusterInfoService;
    private final SnapshotsInfoService snapshotsInfoService;
    private final AllocationDeciders allocationDeciders;
    private final ShardsAllocator shardAllocator;
    private final AllocationService allocationService;

    @Inject
    public TransportClusterAllocationExplainAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, AllocationDeciders allocationDeciders, ShardsAllocator shardAllocator, AllocationService allocationService) {
        super("cluster:monitor/allocation/explain", transportService, clusterService, threadPool, actionFilters, ClusterAllocationExplainRequest::new, indexNameExpressionResolver);
        this.clusterInfoService = clusterInfoService;
        this.snapshotsInfoService = snapshotsInfoService;
        this.allocationDeciders = allocationDeciders;
        this.shardAllocator = shardAllocator;
        this.allocationService = allocationService;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected ClusterAllocationExplainResponse read(StreamInput in) throws IOException {
        return new ClusterAllocationExplainResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterAllocationExplainRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(ClusterAllocationExplainRequest request, ClusterState state, ActionListener<ClusterAllocationExplainResponse> listener) {
        RoutingNodes routingNodes = state.getRoutingNodes();
        ClusterInfo clusterInfo = this.clusterInfoService.getClusterInfo();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, state, clusterInfo, this.snapshotsInfoService.snapshotShardSizes(), System.nanoTime());
        ShardRouting shardRouting = TransportClusterAllocationExplainAction.findShardToExplain(request, allocation);
        logger.debug("explaining the allocation for [{}], found shard [{}]", (Object)request, (Object)shardRouting);
        ClusterAllocationExplanation cae = TransportClusterAllocationExplainAction.explainShard(shardRouting, allocation, request.includeDiskInfo() ? clusterInfo : null, request.includeYesDecisions(), this.allocationService);
        listener.onResponse(new ClusterAllocationExplainResponse(cae));
    }

    public static ClusterAllocationExplanation explainShard(ShardRouting shardRouting, RoutingAllocation allocation, ClusterInfo clusterInfo, boolean includeYesDecisions, AllocationService allocationService) {
        allocation.setDebugMode(includeYesDecisions ? RoutingAllocation.DebugMode.ON : RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS);
        ShardAllocationDecision shardDecision = shardRouting.initializing() || shardRouting.relocating() ? ShardAllocationDecision.NOT_TAKEN : allocationService.explainShardAllocation(shardRouting, allocation);
        return new ClusterAllocationExplanation(shardRouting, shardRouting.currentNodeId() != null ? allocation.nodes().get(shardRouting.currentNodeId()) : null, shardRouting.relocatingNodeId() != null ? allocation.nodes().get(shardRouting.relocatingNodeId()) : null, clusterInfo, shardDecision);
    }

    public static ShardRouting findShardToExplain(ClusterAllocationExplainRequest request, RoutingAllocation allocation) {
        ShardRouting foundShard = null;
        if (request.useAnyUnassignedShard()) {
            RoutingNodes.UnassignedShards.UnassignedIterator ui = allocation.routingNodes().unassigned().iterator();
            if (ui.hasNext()) {
                foundShard = ui.next();
            }
            if (foundShard == null) {
                throw new IllegalArgumentException("unable to find any unassigned shards to explain [" + request + "]");
            }
        } else {
            String index = request.getIndex();
            int shard = request.getShard();
            if (request.isPrimary().booleanValue()) {
                DiscoveryNode primaryNode;
                foundShard = allocation.routingTable().shardRoutingTable(index, shard).primaryShard();
                if (request.getCurrentNode() != null && !(primaryNode = allocation.nodes().resolveNode(request.getCurrentNode())).getId().equals(foundShard.currentNodeId())) {
                    throw new IllegalArgumentException("unable to find primary shard assigned to node [" + request.getCurrentNode() + "]");
                }
            } else {
                List<ShardRouting> replicaShardRoutings = allocation.routingTable().shardRoutingTable(index, shard).replicaShards();
                if (request.getCurrentNode() != null) {
                    DiscoveryNode replicaNode = allocation.nodes().resolveNode(request.getCurrentNode());
                    for (ShardRouting replica : replicaShardRoutings) {
                        if (!replicaNode.getId().equals(replica.currentNodeId())) continue;
                        foundShard = replica;
                        break;
                    }
                    if (foundShard == null) {
                        throw new IllegalArgumentException("unable to find a replica shard assigned to node [" + request.getCurrentNode() + "]");
                    }
                } else if (replicaShardRoutings.size() > 0) {
                    foundShard = replicaShardRoutings.get(0);
                    for (ShardRouting replica : replicaShardRoutings) {
                        if (replica.unassigned()) {
                            foundShard = replica;
                            break;
                        }
                        if (!replica.started() || !foundShard.initializing() && !foundShard.relocating()) continue;
                        foundShard = replica;
                    }
                }
            }
        }
        if (foundShard == null) {
            throw new IllegalArgumentException("unable to find any shards to explain [" + request + "] in the routing table");
        }
        return foundShard;
    }
}

