/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.binder;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BindLexer {
    static final String COMMENTS = "/\\*(?:.*?)\\*/";
    static final String SIMPLE_COMMENT = "--[^\\n]*\\n";
    static final String COMMENTS_OR_WHITESPACE = "((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+";
    static final String FETCH_FIRST_CLAUSE = "FETCH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FIRST((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+([0-9]+((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+)?ROWS?((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY";
    static final String FETCH_FIRST_ONE_CLAUSE = "FETCH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FIRST((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+(1((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+)?ROWS?((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY";
    static final String FETCH_FIRST = "FETCH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FIRST";
    static final String CONTAINS_FETCH_FIRST = ".+FETCH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FIRST((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+([0-9]+((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+)?ROWS?((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY.*";
    static final String FETCH_FIRST_ROW = "FETCH FIRST ROW ONLY";
    static final String UPDATE_START = "FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+UPDATE";
    static final String FOR_UPDATE = "FOR UPDATE";
    static final String READ_ONLY_START = "FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((READ)|(FETCH))((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY";
    static final String FOR_READ_ONLY = "FOR READ ONLY";
    static final String OPTIMIZE_FOR_START = "OPTIMIZE((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ROWS?";
    static final String ISOLATION_START = "WITH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((CS)|(UR)|(RR)|(RS))";
    static final String QUERYNO_START = "QUERYNO((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+";
    static final String SKIP_LOCKED_DATA_START = "SKIP((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+LOCKED((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+DATA";
    static final String SELECT_STATEMENT_CLOSE = "((((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+UPDATE)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((READ)|(FETCH))((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+OPTIMIZE((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ROWS?)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+WITH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((CS)|(UR)|(RR)|(RS)))|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+QUERYNO((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+SKIP((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+LOCKED((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+DATA)).*";
    public static final String EMPTY_OR_WHITESPACE = "(\\s)*";
    public static final String LINE_END = "[\n\r]";
    public static final String COMMENT_LINE_START = " * ";
    public static final String QUOTE_START = "    \"";
    public static final String QUOTE_END = "\"";
    public static final String QUOTED_LINE_END = "\\n\" +";
    static final String SUBSTATEMENT = "\\([^)]*\\)";
    static final String DELIMITED_IDENTIFIER_SINGLE = "'[^']*'";
    static final String DELIMITED_IDENTIFIER_DOUBLE = "\"[^\"]*\"";
    static final String FROM = "((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FROM((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+";
    static final String SIMPLE_FROM = "FROM";
    static final String MERGE_USING = "USING(\\s)*\\((\\s)*VALUES(\\s)*\\([^)]+\\)(\\s)*\\)";
    static final String MULTI_ROW_CLAUSE = " FOR :H ROWS ";
    static final String UNION = "((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+UNION((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+";
    static final String INTERSECT = "((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+INTERSECT((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+";
    static final String EXCEPT = "((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+EXCEPT((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+";
    public static final int patternFlags = 98;
    public static final Pattern regExPatternContainsFetchFirst = Pattern.compile(".+FETCH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FIRST((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+([0-9]+((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+)?ROWS?((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY.*", 98);
    public static final Pattern regExPatternFetchFirst = Pattern.compile("FETCH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FIRST((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+([0-9]+((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+)?ROWS?((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY", 98);
    public static final Pattern regExPatternFetchFirstOne = Pattern.compile("FETCH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FIRST((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+(1((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+)?ROWS?((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY", 98);
    public static final Pattern regExPatternFetchFirstOneMissing = Pattern.compile("FETCH FIRST ROW ONLY", 98);
    public static final Pattern regExPatternFetchRows = Pattern.compile("FETCH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FIRST", 98);
    public static final Pattern regExPatternUpdate = Pattern.compile("FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+UPDATE", 98);
    public static final Pattern regExPatternReadOnly = Pattern.compile("FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((READ)|(FETCH))((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY", 98);
    public static final Pattern regExPatternOptimizeFor = Pattern.compile("OPTIMIZE((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ROWS?", 98);
    public static final Pattern regExPatternIsolation = Pattern.compile("WITH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((CS)|(UR)|(RR)|(RS))", 98);
    public static final Pattern regExPatternQueryNo = Pattern.compile("QUERYNO((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+", 98);
    public static final Pattern regExPatternSkipLockedData = Pattern.compile("SKIP((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+LOCKED((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+DATA", 98);
    public static final Pattern regExPatternSelectStatementClose = Pattern.compile("((((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+UPDATE)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((READ)|(FETCH))((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ONLY)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+OPTIMIZE((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FOR((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+ROWS?)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+WITH((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+((CS)|(UR)|(RR)|(RS)))|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+QUERYNO((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+[0-9]+)|(((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+SKIP((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+LOCKED((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+DATA)).*", 98);
    public static final Pattern regExPatternEmptyOrWhitespace = Pattern.compile("(\\s)*", 98);
    public static final Pattern regExPatternLineEnd = Pattern.compile("[\n\r]", 98);
    public static final Pattern regExPatternComments = Pattern.compile("/\\*(?:.*?)\\*/", 98);
    public static final Pattern regExPatternCommentsOrWhitespace = Pattern.compile("((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+", 98);
    public static final Pattern regExPatternDelimitedIdSingle = Pattern.compile("'[^']*'", 98);
    public static final Pattern regExPatternDelimitedIdDouble = Pattern.compile("\"[^\"]*\"", 98);
    public static final Pattern regExPatternSubstatement = Pattern.compile("\\([^)]*\\)", 98);
    public static final Pattern regExPatternFrom = Pattern.compile("((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+FROM((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+", 98);
    public static final Pattern regExPatternSimpleComment = Pattern.compile("--[^\\n]*\\n", 98);
    public static final Pattern regExPatternMergeUsing = Pattern.compile("USING(\\s)*\\((\\s)*VALUES(\\s)*\\([^)]+\\)(\\s)*\\)", 98);
    public static final Pattern regExPatternUnion = Pattern.compile("((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+UNION((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+", 98);
    public static final Pattern regExPatternIntersect = Pattern.compile("((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+INTERSECT((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+", 98);
    public static final Pattern regExPatternExcept = Pattern.compile("((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+EXCEPT((/\\*(?:.*?)\\*/)|(--[^\\n]*\\n)|(\\s))+", 98);

    public static String getSingleRowQuery(String string, SqlStatementType sqlStatementType, int n2, int[] nArray) {
        String string2 = string;
        if (!BindLexer.outerFetchFirstExists(string) && SqlStatementType.VALUES != sqlStatementType) {
            string2 = BindLexer.addNewOuterFetchFirst(string);
        }
        string2 = BindLexer.addSelectIntoHostVars(string2, sqlStatementType, n2, nArray);
        return string2;
    }

    public static String getMergeWithMultiRowClause(String string) {
        Matcher matcher;
        String string2 = BindLexer.getSQLWithoutQuotedIds(string);
        Matcher matcher2 = regExPatternMergeUsing.matcher(string2);
        String string3 = MULTI_ROW_CLAUSE;
        String string4 = " NOT ATOMIC CONTINUE ON SQLEXCEPTION ";
        if (matcher2.find()) {
            int n2 = matcher2.end() - 1;
            int n3 = matcher2.start();
            n3 = string2.indexOf(40, n3);
            ++n3;
            n3 = string2.indexOf(40, n3);
            int n4 = 0;
            for (int i10 = n3; i10 < string2.length(); ++i10) {
                char c10 = string2.charAt(i10);
                if (c10 == '(') {
                    ++n4;
                    continue;
                }
                if (c10 != ')' || --n4 != -1) continue;
                n2 = i10;
                break;
            }
            string = string.substring(0, n2) + MULTI_ROW_CLAUSE + string.substring(n2);
        }
        if (!string.contains(string3)) {
            Pattern pattern = Pattern.compile("(\\)\\s*[Aa][Ss])\\s+");
            Pattern pattern2 = Pattern.compile("(\\)\\s*[Oo][Nn])\\s*");
            Matcher matcher3 = pattern.matcher(string);
            Matcher matcher4 = pattern2.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            if (matcher3.find()) {
                matcher3.appendReplacement(stringBuffer, string3 + " ) AS ");
                matcher3.appendTail(stringBuffer);
            } else if (matcher4.find()) {
                matcher4.appendReplacement(stringBuffer, string3 + " ) ON ");
                matcher4.appendTail(stringBuffer);
            }
            string = stringBuffer.toString();
        }
        if (!(matcher = StaticProfileConstants.notAtomicCont.matcher(string)).find()) {
            string = string + string4;
        }
        return string;
    }

    public static String getSQLWithoutQuotedIds(String string) {
        Iterable<int[]> iterable = BindLexer.getIgnoreRanges(string);
        String string2 = string;
        for (int[] nArray : iterable) {
            string2 = BindLexer.replaceRangeWithWhitespace(nArray, string2);
        }
        return string2;
    }

    public static String getQueryWithUpdateClause(String string) {
        String string2 = string;
        if (!BindLexer.updateClauseExists(string) && !BindLexer.readOnlyClauseExists(string)) {
            string2 = BindLexer.addUpdateClause(string);
        }
        return string2;
    }

    public static String getQueryWithReadOnlyClause(String string) {
        String string2 = string;
        if (!BindLexer.updateClauseExists(string) && !BindLexer.readOnlyClauseExists(string)) {
            string2 = BindLexer.addReadOnlyClause(string);
        }
        return string2;
    }

    private static boolean updateClauseExists(String string) {
        boolean bl2 = false;
        Iterable<int[]> iterable = BindLexer.getIgnoreRanges(string);
        Matcher matcher = regExPatternUpdate.matcher(string);
        if (BindLexer.find(matcher, iterable)) {
            bl2 = true;
        }
        return bl2;
    }

    private static boolean readOnlyClauseExists(String string) {
        boolean bl2 = false;
        Iterable<int[]> iterable = BindLexer.getIgnoreRanges(string);
        Matcher matcher = regExPatternReadOnly.matcher(string);
        if (BindLexer.find(matcher, iterable)) {
            bl2 = true;
        }
        if (BindLexer.find(matcher = StaticProfileConstants.forFetchOnlyPat.matcher(string), iterable)) {
            bl2 = true;
        }
        return bl2;
    }

    private static String addUpdateClause(String string) {
        return string + " " + FOR_UPDATE;
    }

    private static String addReadOnlyClause(String string) {
        return string + " " + FOR_READ_ONLY;
    }

    private static String addSelectIntoHostVars(String string, SqlStatementType sqlStatementType, int n2, int[] nArray) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = BindLexer.getInsertionLocationForIntoClause(sqlStatementType, string);
        if (0 == n3) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", string), null, 11268);
        }
        int n4 = 0;
        int n5 = 0;
        EscapeLexer escapeLexer = new EscapeLexer(string);
        while (n5 < n3 && (n5 = escapeLexer.findNextNotInQuotedString('?', '?', true, true)) != -1) {
            if (n5 >= n3) continue;
            ++n4;
        }
        nArray[0] = n4;
        stringBuffer.append(string.substring(0, n3));
        stringBuffer.append(" INTO ? ");
        for (int i10 = 2; i10 <= n2; ++i10) {
            stringBuffer.append(", ? ");
        }
        if (string.length() > n3) {
            stringBuffer.append(string.substring(n3));
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    private static String replaceMatchWithWhitespace(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
            int n2 = matcher.end() - matcher.start();
            for (int i10 = 0; i10 < n2; ++i10) {
                stringBuffer.append(" ");
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static int getInsertionLocationForIntoClause(SqlStatementType sqlStatementType, String string) {
        if (SqlStatementType.QUERY == sqlStatementType || SqlStatementType.SINGLE_ROW_QUERY == sqlStatementType) {
            Iterable<int[]> iterable = BindLexer.getIgnoreRanges(string);
            String string2 = BindLexer.getStrippedStringForFromSearch(string, iterable);
            Matcher matcher = regExPatternFrom.matcher(string2);
            int n2 = 0;
            if (matcher.find()) {
                n2 = matcher.start();
                n2 = string2.toUpperCase().indexOf(SIMPLE_FROM, n2);
            }
            return n2;
        }
        if (SqlStatementType.VALUES == sqlStatementType) {
            return string.length();
        }
        throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{sqlStatementType}), null, 11269);
    }

    public static String getStrippedStringForFromSearch(String string, Iterable<int[]> iterable) {
        Object object = string;
        for (int[] nArray : iterable) {
            object = BindLexer.replaceRangeWithWhitespace(nArray, (String)object);
        }
        String string2 = BindLexer.replaceParentheticalsContents((String)object);
        if (string2.trim().length() > 0) {
            object = string2;
        }
        return object;
    }

    private static String replaceParentheticalsContents(String string) {
        if (string.indexOf(40) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        stringBuilder.setLength(0);
        int n3 = string.length();
        for (int i10 = 0; i10 < n3; ++i10) {
            char c10 = string.charAt(i10);
            if (c10 == '(') {
                ++n2;
                stringBuilder.append(' ');
                continue;
            }
            if (n2 > 0) {
                if (c10 == ')') {
                    --n2;
                }
                stringBuilder.append(' ');
                continue;
            }
            stringBuilder.append(c10);
        }
        string = stringBuilder.toString();
        return string;
    }

    private static boolean usesFromAsIdentifier(String string, Iterable<int[]> iterable) {
        boolean bl2 = false;
        String string2 = BindLexer.getStrippedStringForFromSearch(string, iterable);
        Matcher matcher = regExPatternFrom.matcher(string2);
        int n2 = 0;
        while (matcher.find()) {
            ++n2;
        }
        if (n2 > 1) {
            bl2 = true;
        }
        return bl2;
    }

    private static boolean usesUnionOrIntersectOrExcept(String string, Iterable<int[]> iterable) {
        String string2 = BindLexer.getStrippedStringForFromSearch(string, iterable);
        Matcher matcher = regExPatternFrom.matcher(string2);
        if (!matcher.find()) {
            matcher = regExPatternUnion.matcher(string2);
            if (matcher.find()) {
                return true;
            }
            matcher = regExPatternIntersect.matcher(string2);
            if (matcher.find()) {
                return true;
            }
            matcher = regExPatternExcept.matcher(string2);
            if (matcher.find()) {
                return true;
            }
        } else {
            do {
                int n2 = matcher.end();
                if (!matcher.find()) continue;
                int n3 = matcher.start();
                String string3 = string2.substring(n2, n3);
                Matcher matcher2 = regExPatternUnion.matcher(string2);
                if (matcher2.find()) {
                    return true;
                }
                matcher2 = regExPatternIntersect.matcher(string2);
                if (matcher2.find()) {
                    return true;
                }
                matcher2 = regExPatternExcept.matcher(string2);
                if (!matcher2.find()) continue;
                return true;
            } while (matcher.find());
        }
        return false;
    }

    public static boolean isSingleRowEligible(String string) {
        try {
            Iterable<int[]> iterable = BindLexer.getIgnoreRanges(string);
            if (BindLexer.find(regExPatternUpdate.matcher(string), iterable)) {
                return false;
            }
            if (BindLexer.find(regExPatternOptimizeFor.matcher(string), iterable)) {
                return false;
            }
            if (BindLexer.find(regExPatternReadOnly.matcher(string), iterable)) {
                return false;
            }
            if (BindLexer.find(regExPatternFetchFirst.matcher(string), iterable)) {
                int[] nArray = BindLexer.getRangeLastFetchFirst(string, iterable);
                String string2 = string.substring(nArray[0], nArray[1]);
                Iterable<int[]> iterable2 = BindLexer.getIgnoreRanges(string2);
                if (!BindLexer.find(regExPatternFetchFirstOne.matcher(string2), iterable2)) {
                    return false;
                }
            }
            if (BindLexer.usesFromAsIdentifier(string, iterable)) {
                return false;
            }
            return !BindLexer.usesUnionOrIntersectOrExcept(string, iterable);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean find(Matcher matcher, Iterable<int[]> iterable) {
        boolean bl2 = false;
        while (matcher.find()) {
            boolean bl3 = BindLexer.isInRange(matcher.start(), iterable);
            if (bl3) continue;
            bl2 = true;
        }
        return bl2;
    }

    public static boolean outerFetchFirstExists(String string) {
        int[] nArray;
        boolean bl2 = false;
        Iterable<int[]> iterable = BindLexer.getIgnoreRanges(string);
        Matcher matcher = regExPatternFetchFirst.matcher(string);
        if (BindLexer.find(matcher, iterable) && BindLexer.isOuterFetchFirst((nArray = BindLexer.getRangeLastFetchFirst(string, iterable))[1], string)) {
            bl2 = true;
        }
        return bl2;
    }

    private static int[] getRangeLastFetchFirst(String string, Iterable<int[]> iterable) {
        int n2 = 0;
        int n3 = 0;
        Matcher matcher = regExPatternFetchFirst.matcher(string);
        while (matcher.find()) {
            boolean bl2 = BindLexer.isInRange(matcher.start(), iterable);
            if (bl2) continue;
            n2 = matcher.start();
            n3 = matcher.end();
        }
        return new int[]{n2, n3};
    }

    private static boolean isOuterFetchFirst(int n2, String string) {
        boolean bl2 = false;
        String string2 = string.substring(n2);
        if (regExPatternSelectStatementClose.matcher(string2).matches() || regExPatternEmptyOrWhitespace.matcher(string2).matches() || regExPatternCommentsOrWhitespace.matcher(string2).matches()) {
            bl2 = true;
        }
        return bl2;
    }

    private static boolean isInRange(int n2, Iterable<int[]> iterable) {
        boolean bl2 = false;
        for (int[] nArray : iterable) {
            if (n2 < nArray[0] || n2 >= nArray[1]) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public static Iterable<int[]> getIgnoreRanges(String string) {
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        String string2 = string;
        int n2 = 0;
        while (n2 < string.length()) {
            Iterator iterator;
            Matcher matcher;
            Matcher matcher2;
            Matcher matcher3;
            int[] nArray = new int[]{0, 0};
            TreeMap<Integer, Matcher> treeMap = new TreeMap<Integer, Matcher>();
            Matcher matcher4 = regExPatternComments.matcher(string2);
            if (matcher4.find()) {
                treeMap.put(matcher4.start(), matcher4);
            }
            if ((matcher3 = regExPatternDelimitedIdSingle.matcher(string2)).find()) {
                treeMap.put(matcher3.start(), matcher3);
            }
            if ((matcher2 = regExPatternDelimitedIdDouble.matcher(string2)).find()) {
                treeMap.put(matcher2.start(), matcher2);
            }
            if ((matcher = regExPatternSimpleComment.matcher(string2)).find()) {
                treeMap.put(matcher.start(), matcher);
            }
            if ((iterator = treeMap.entrySet().iterator()) != null && iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Matcher matcher5 = (Matcher)entry.getValue();
                nArray[0] = matcher5.start();
                nArray[1] = matcher5.end();
                linkedList.add(nArray);
                string2 = BindLexer.replaceRangeWithWhitespace(nArray, string2);
                n2 = nArray[1];
                continue;
            }
            n2 = string.length();
        }
        return linkedList;
    }

    private static String replaceRangeWithWhitespace(int[] nArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, nArray[0]));
        int n2 = nArray[1] - nArray[0];
        for (int i10 = 0; i10 < n2; ++i10) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string.substring(nArray[1]));
        return stringBuffer.toString();
    }

    private static String addNewOuterFetchFirst(String string) {
        String string2 = string + " " + FETCH_FIRST_ROW;
        Matcher matcher = regExPatternSelectStatementClose.matcher(string);
        if (matcher.find()) {
            int n2 = matcher.start();
            string2 = string.substring(0, n2) + " " + FETCH_FIRST_ROW + " " + string.substring(n2);
        }
        return string2;
    }

    public static String getJavaLineBreakCommentedString(String string, String string2) {
        String string3 = string2 + COMMENT_LINE_START;
        String string4 = "\n";
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = string.replace("*/", "*\\/");
        Matcher matcher = regExPatternLineEnd.matcher(string5);
        String string6 = "$0";
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, string6 + string3);
        }
        matcher.appendTail(stringBuffer);
        stringBuffer.insert(0, string3);
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    public static String getJavaLineBreakQuotedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = regExPatternLineEnd.matcher(string);
        while (matcher.find()) {
            stringBuffer.append(QUOTE_START);
            matcher.appendReplacement(stringBuffer, "");
            stringBuffer.append(QUOTED_LINE_END);
            stringBuffer.append("\n");
        }
        stringBuffer.append(QUOTE_START);
        matcher.appendTail(stringBuffer);
        stringBuffer.append(QUOTE_END);
        return stringBuffer.toString();
    }

    public static String removeFinalSemicolon(String string) {
        String string2 = string;
        Iterable<int[]> iterable = BindLexer.getIgnoreRanges(string);
        String string3 = string;
        for (int[] object : iterable) {
            string3 = BindLexer.replaceRangeWithWhitespace(object, string3);
        }
        int n2 = string3.lastIndexOf(59);
        if (n2 > 0) {
            String string4 = string.substring(n2 + 1);
            Matcher matcher = regExPatternCommentsOrWhitespace.matcher(string4);
            if (string4.length() == 0 || matcher.matches()) {
                string2 = string.substring(0, n2);
                if (n2 < string.length()) {
                    string2 = string2 + string.substring(n2 + 1);
                }
                ToolsLogger.getLogger().log(Level.WARNING, Messages.getText("MSG_BIND_SEMICOLON", string));
            }
        }
        return string2;
    }
}

