/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.cloud.objectstorage.SDKGlobalConfiguration;
import com.ibm.cloud.objectstorage.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.ibm.cloud.objectstorage.http.conn.ssl.SdkTLSSocketFactory;
import com.ibm.cloud.objectstorage.http.settings.HttpClientSettings;
import com.ibm.cloud.objectstorage.log.InternalLogApi;
import com.ibm.cloud.objectstorage.log.InternalLogFactory;
import com.ibm.cloud.objectstorage.oauth.DefaultTokenManager;
import com.ibm.cloud.objectstorage.oauth.OAuthServiceException;
import com.ibm.cloud.objectstorage.oauth.Token;
import com.ibm.cloud.objectstorage.oauth.TokenProvider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class DelegateTokenProvider
implements TokenProvider {
    protected static final InternalLogApi log = InternalLogFactory.getLog(DelegateTokenProvider.class);
    private static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String GRANT_TYPE = "urn:ibm:params:oauth:grant-type:apikey";
    private static final String RESPONSE_TYPE = "delegated_refresh_token";
    private static final String TOKEN_TIMEOUT = "518400";
    private String apiKey;
    private String iamEndpoint = SDKGlobalConfiguration.IAM_ENDPOINT;
    private HttpClientSettings httpClientSettings;
    private String receiverClientId = "aspera_ats";

    public DelegateTokenProvider(String apiKey) {
        this.apiKey = apiKey;
    }

    private void setIamEndpoint(String iamEndpoint) {
        this.iamEndpoint = iamEndpoint;
    }

    public void setHttpClientSettings(HttpClientSettings httpClientSettings) {
        this.httpClientSettings = httpClientSettings;
    }

    private void setReceiverClientId(String receiverClientId) {
        this.receiverClientId = receiverClientId;
    }

    public DelegateTokenProvider withIamEndpoint(String iamEndpoint) {
        this.setIamEndpoint(iamEndpoint);
        return this;
    }

    public DelegateTokenProvider withReceiverClientId(String receiverClientId) {
        this.setReceiverClientId(receiverClientId);
        return this;
    }

    @Override
    public Token retrieveToken() {
        log.debug("AsperaDelegateTokenProvider retrieveToken()");
        try {
            SSLContext sslContext;
            if (SDKGlobalConfiguration.isCertCheckingDisabled()) {
                if (log.isWarnEnabled()) {
                    log.warn("SSL Certificate checking for endpoints has been explicitly disabled.");
                }
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new ApacheConnectionManagerFactory.TrustingX509TrustManager()}, null);
            } else {
                sslContext = SSLContexts.createDefault();
            }
            SdkTLSSocketFactory sslsf = new SdkTLSSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
            HttpClientBuilder builder = HttpClientBuilder.create();
            if (this.httpClientSettings != null) {
                DefaultTokenManager.addProxyConfig(builder, this.httpClientSettings);
            }
            CloseableHttpClient client = builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            HttpPost post = new HttpPost(this.iamEndpoint);
            post.setHeader("Content-Type", CONTENT_TYPE);
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            urlParameters.add(new BasicNameValuePair("grant_type", GRANT_TYPE));
            urlParameters.add(new BasicNameValuePair("response_type", RESPONSE_TYPE));
            urlParameters.add(new BasicNameValuePair("receiver_client_ids", this.receiverClientId));
            urlParameters.add(new BasicNameValuePair("apikey", this.apiKey));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                log.info("Response code= " + response.getStatusLine().getStatusCode() + ", Reason= " + response.getStatusLine().getReasonPhrase() + ".Throwing OAuthServiceException");
                OAuthServiceException exception = new OAuthServiceException("Token retrival from IAM service failed token");
                exception.setStatusCode(response.getStatusLine().getStatusCode());
                exception.setStatusMessage(response.getStatusLine().getReasonPhrase());
                throw exception;
            }
            HttpEntity entity = response.getEntity();
            String resultStr = EntityUtils.toString((HttpEntity)entity);
            ObjectMapper mapper = new ObjectMapper();
            Token token = (Token)mapper.readValue(resultStr, Token.class);
            token.setExpires_in(TOKEN_TIMEOUT);
            token.setExpiration(Long.toString(System.currentTimeMillis() / 1000L + 518400L));
            return token;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }
}

