/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.text;

import org.beetl.core.text.Fragment;
import org.beetl.core.text.HtmlTagEndFragment;
import org.beetl.core.text.HtmlTagStartFragment;
import org.beetl.core.text.PlaceHolderFragment;
import org.beetl.core.text.ScriptBlockFragment;
import org.beetl.core.text.Source;
import org.beetl.core.text.TextFragment;

public class CRFragment
extends Fragment {
    char[] cr;

    public CRFragment(Source source) {
        super(source);
        int size = source.lastCrSize;
        this.cr = source.consumeAndGetCR(size);
    }

    @Override
    public StringBuilder getScript() {
        StringBuilder script = new StringBuilder();
        Integer varName = this.source.getParser().getRandomeTextVarName();
        script.append("<$" + varName + ">>");
        script.append(this.cr);
        this.source.parser.getTextVars().put(varName, new String(this.cr));
        return script;
    }

    @Override
    public Fragment consumeAndReturnNext() {
        this.endLine = this.source.curLine - 1;
        if (!this.source.isEof()) {
            if (this.source.isPlaceHolderStart()) {
                return new PlaceHolderFragment(this.source);
            }
            if (this.source.isScriptStart()) {
                return new ScriptBlockFragment(this.source);
            }
            if (this.source.isHtmlTagStart()) {
                return new HtmlTagStartFragment(this.source);
            }
            if (this.source.isHtmlTagEnd()) {
                return new HtmlTagEndFragment(this.source);
            }
            if (this.source.isCrStart()) {
                return new CRFragment(this.source);
            }
            return new TextFragment(this.source);
        }
        return null;
    }
}

