/*
 * Decompiled with CFR 0.152.
 */
package com.obs.log;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.utils.AccessLoggerUtils;
import java.lang.reflect.Method;

public class Log4j2Logger
implements ILogger {
    private final Object logger;
    private volatile int isInfoE = -1;
    private volatile int isDebugE = -1;
    private volatile int isErrorE = -1;
    private volatile int isWarnE = -1;
    private volatile int isTraceE = -1;

    Log4j2Logger(Object logger) {
        this.logger = logger;
    }

    public boolean isInfoEnabled() {
        if (this.isInfoE == -1) {
            try {
                this.isInfoE = this.logger != null && LoggerMethodHolder.isInfo != null && (Boolean)LoggerMethodHolder.isInfo.invoke(this.logger, new Object[0]) != false ? 1 : 0;
            }
            catch (Exception e) {
                this.isInfoE = 0;
            }
        }
        return this.isInfoE == 1;
    }

    public void info(CharSequence msg) {
        if (this.logger != null && LoggerMethodHolder.info != null) {
            try {
                LoggerMethodHolder.info.invoke(this.logger, msg, null);
                AccessLoggerUtils.appendLog(msg, "info");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void info(Object obj) {
        if (this.logger != null && LoggerMethodHolder.info != null) {
            try {
                LoggerMethodHolder.info.invoke(this.logger, obj, null);
                AccessLoggerUtils.appendLog(obj, "info");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void info(Object obj, Throwable e) {
        if (this.logger != null && LoggerMethodHolder.info != null) {
            try {
                LoggerMethodHolder.info.invoke(this.logger, obj, e);
                AccessLoggerUtils.appendLog(obj, "info");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isWarnEnabled() {
        if (this.isWarnE == -1) {
            try {
                this.isWarnE = this.logger != null && LoggerMethodHolder.isWarn != null && (Boolean)LoggerMethodHolder.isWarn.invoke(this.logger, new Object[0]) != false ? 1 : 0;
            }
            catch (Exception e) {
                this.isWarnE = 0;
            }
        }
        return this.isWarnE == 1;
    }

    public void warn(CharSequence msg) {
        if (this.logger != null && LoggerMethodHolder.warn != null) {
            try {
                LoggerMethodHolder.warn.invoke(this.logger, msg, null);
                AccessLoggerUtils.appendLog(msg, "warn");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void warn(Object obj) {
        if (this.logger != null && LoggerMethodHolder.warn != null) {
            try {
                LoggerMethodHolder.warn.invoke(this.logger, obj, null);
                AccessLoggerUtils.appendLog(obj, "warn");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void warn(Object obj, Throwable e) {
        if (this.logger != null && LoggerMethodHolder.warn != null) {
            try {
                LoggerMethodHolder.warn.invoke(this.logger, obj, e);
                AccessLoggerUtils.appendLog(obj, "warn");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isErrorEnabled() {
        if (this.isErrorE == -1) {
            try {
                this.isErrorE = this.logger != null && LoggerMethodHolder.isError != null && (Boolean)LoggerMethodHolder.isError.invoke(this.logger, new Object[0]) != false ? 1 : 0;
            }
            catch (Exception e) {
                this.isErrorE = 0;
            }
        }
        return this.isErrorE == 1;
    }

    public void error(CharSequence msg) {
        if (this.logger != null && LoggerMethodHolder.error != null) {
            try {
                LoggerMethodHolder.error.invoke(this.logger, msg, null);
                AccessLoggerUtils.appendLog(msg, "error");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void error(Object obj) {
        if (this.logger != null && LoggerMethodHolder.error != null) {
            try {
                LoggerMethodHolder.error.invoke(this.logger, obj, null);
                AccessLoggerUtils.appendLog(obj, "error");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void error(Object obj, Throwable e) {
        if (this.logger != null && LoggerMethodHolder.error != null) {
            try {
                LoggerMethodHolder.error.invoke(this.logger, obj, e);
                AccessLoggerUtils.appendLog(obj, "error");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isDebugEnabled() {
        if (this.isDebugE == -1) {
            try {
                this.isDebugE = this.logger != null && LoggerMethodHolder.isDebug != null && (Boolean)LoggerMethodHolder.isDebug.invoke(this.logger, new Object[0]) != false ? 1 : 0;
            }
            catch (Exception e) {
                this.isDebugE = 0;
            }
        }
        return this.isDebugE == 1;
    }

    public void debug(CharSequence msg) {
        if (this.logger != null && LoggerMethodHolder.debug != null) {
            try {
                LoggerMethodHolder.debug.invoke(this.logger, msg, null);
                AccessLoggerUtils.appendLog(msg, "debug");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void debug(Object obj) {
        if (this.logger != null && LoggerMethodHolder.debug != null) {
            try {
                LoggerMethodHolder.debug.invoke(this.logger, obj, null);
                AccessLoggerUtils.appendLog(obj, "debug");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void debug(Object obj, Throwable e) {
        if (this.logger != null && LoggerMethodHolder.debug != null) {
            try {
                LoggerMethodHolder.debug.invoke(this.logger, obj, e);
                AccessLoggerUtils.appendLog(obj, "debug");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isTraceEnabled() {
        if (this.isTraceE == -1) {
            try {
                this.isTraceE = this.logger != null && LoggerMethodHolder.isTrace != null && (Boolean)LoggerMethodHolder.isTrace.invoke(this.logger, new Object[0]) != false ? 1 : 0;
            }
            catch (Exception e) {
                this.isTraceE = 0;
            }
        }
        return this.isTraceE == 1;
    }

    public void trace(CharSequence msg) {
        if (this.logger != null && LoggerMethodHolder.trace != null) {
            try {
                LoggerMethodHolder.trace.invoke(this.logger, msg, null);
                AccessLoggerUtils.appendLog(msg, "trace");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void trace(Object obj) {
        if (this.logger != null && LoggerMethodHolder.trace != null) {
            try {
                LoggerMethodHolder.trace.invoke(this.logger, obj, null);
                AccessLoggerUtils.appendLog(obj, "trace");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void trace(Object obj, Throwable e) {
        if (this.logger != null && LoggerMethodHolder.trace != null) {
            try {
                LoggerMethodHolder.trace.invoke(this.logger, obj, e);
                AccessLoggerUtils.appendLog(obj, "trace");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void accessRecord(Object obj) {
        if (this.logger != null && LoggerMethodHolder.info != null) {
            try {
                LoggerMethodHolder.info.invoke(this.logger, obj, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class LoggerMethodHolder {
        private static Method info;
        private static Method warn;
        private static Method debug;
        private static Method trace;
        private static Method error;
        private static Method isInfo;
        private static Method isDebug;
        private static Method isError;
        private static Method isWarn;
        private static Method isTrace;

        private LoggerMethodHolder() {
        }

        static {
            try {
                if (LoggerBuilder.GetLoggerHolder.loggerClass != null) {
                    info = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("info", Object.class, Throwable.class);
                    warn = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("warn", Object.class, Throwable.class);
                    error = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("error", Object.class, Throwable.class);
                    debug = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("debug", Object.class, Throwable.class);
                    trace = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("trace", Object.class, Throwable.class);
                    isInfo = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isInfoEnabled", new Class[0]);
                    isDebug = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isDebugEnabled", new Class[0]);
                    isError = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isErrorEnabled", new Class[0]);
                    isWarn = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isWarnEnabled", new Class[0]);
                    isTrace = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isTraceEnabled", new Class[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

