/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.security;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.AbstractClient;
import com.obs.services.internal.utils.PropertyManager;
import com.obs.services.model.HttpMethodEnum;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import shade.okhttp3.Call;
import shade.okhttp3.MediaType;
import shade.okhttp3.OkHttpClient;
import shade.okhttp3.Request;
import shade.okhttp3.RequestBody;
import shade.okhttp3.Response;

public class EcsSecurityUtils {
    private static final String OPENSTACK_METADATA_ROOT = "/openstack/latest";
    private static final String METADATA_ROOT = "/meta-data/latest";
    private static final String ECS_METADATA_SERVICE_URL = PropertyManager.getInstance("obs").getFormattedString("ecs.metadata.service.url", new Object[0]);
    private static final String EC2_METADATA_SERVICE_OVERRIDE_URL = "ecsMetadataServiceOverrideEndpoint";
    private static final long HTTP_CONNECT_TIMEOUT_VALUE = 30000L;
    private static OkHttpClient httpClient = new OkHttpClient.Builder().followRedirects(false).retryOnConnectionFailure(true).cache(null).connectTimeout(30000L, TimeUnit.MILLISECONDS).writeTimeout(30000L, TimeUnit.MILLISECONDS).readTimeout(30000L, TimeUnit.MILLISECONDS).build();
    private static final String METADATA_TOKEN_HEADER_KEY = "X-Metadata-Token";
    private static final String METADATA_TOKEN_TTL = "X-Metadata-Token-Ttl-Seconds";
    public static final int DEFAULT_METADATA_TOKEN_TTL_SECONDS = 21600;
    private static final String METADATA_TOKEN_RESOURCE_PATH = "/meta-data/latest/api/token";
    private static final String OPENSTACK_SECURITY_KEY_RESOURCE_PATH = "/openstack/latest/securitykey";
    private static final ILogger ILOG = LoggerBuilder.getLogger(AbstractClient.class);

    public static String getSecurityKeyInfoWithDetail() throws IOException {
        return EcsSecurityUtils.getSecurityKeyInfoWithDetail(21600);
    }

    public static String getSecurityKeyInfoWithDetail(int metadataTokenTTLSeconds) throws IOException {
        String metadataApiToken = EcsSecurityUtils.getMetadataApiToken(metadataTokenTTLSeconds);
        String securityKeyResourcePath = EcsSecurityUtils.getEndpointForECSMetadataService() + OPENSTACK_SECURITY_KEY_RESOURCE_PATH;
        if (metadataApiToken.isEmpty()) {
            return EcsSecurityUtils.getResourceWithDetail(securityKeyResourcePath);
        }
        return EcsSecurityUtils.getResourceWithDetailWithMetaDataToken(securityKeyResourcePath, metadataApiToken);
    }

    public static String getEndpointForECSMetadataService() {
        String overridUrl = System.getProperty(EC2_METADATA_SERVICE_OVERRIDE_URL);
        return overridUrl != null ? overridUrl : ECS_METADATA_SERVICE_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceWithDetail(String endpoint) throws IOException {
        Request.Builder builder = new Request.Builder();
        builder.header("Accept", "*/*");
        Request request = builder.url(endpoint).get().build();
        Call c = httpClient.newCall(request);
        String content = "";
        try (Response res = null;){
            res = c.execute();
            String header = "";
            if (res.headers() != null) {
                header = res.headers().toString();
            }
            if (res.body() != null) {
                content = res.body().string();
            }
            if (res.code() < 200 || res.code() >= 300) {
                String errorMessage = "Get securityKey from ECS failed, Code : " + res.code() + "; Headers : " + header + "; Content : " + content;
                throw new IllegalArgumentException(errorMessage);
            }
            String string = content;
            return string;
        }
    }

    private static String getMetadataApiToken(int metadataTokenTTLSeconds) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(METADATA_TOKEN_TTL, String.valueOf(metadataTokenTTLSeconds));
        ECSResult ecsResult = EcsSecurityUtils.executeEcsRequest(EcsSecurityUtils.getEndpointForECSMetadataService() + METADATA_TOKEN_RESOURCE_PATH, headers, HttpMethodEnum.PUT, "", null);
        if (ecsResult.code == 404 || ecsResult.code == 405) {
            ILOG.debug("X-Metadata-Token not supported," + ecsResult);
            return "";
        }
        if (ecsResult.code < 200 || ecsResult.code >= 300) {
            String errorMessage = "Get X-Metadata-Token with X-Metadata-Token-Ttl-Seconds:" + metadataTokenTTLSeconds + " from ECS failed," + ecsResult;
            ILOG.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        ILOG.debug("X-Metadata-Token refreshed succeeded.");
        return ecsResult.content;
    }

    private static String getResourceWithDetailWithMetaDataToken(String endpoint, String metadataApiToken) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(METADATA_TOKEN_HEADER_KEY, metadataApiToken);
        ECSResult ecsResult = EcsSecurityUtils.executeEcsRequest(endpoint, headers, HttpMethodEnum.GET, "", null);
        if (ecsResult.code < 200 || ecsResult.code >= 300) {
            String errorMessage = "Get securityKey by X-Metadata-Token from ECS failed," + ecsResult;
            ILOG.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        ILOG.debug("getResourceWithDetailWithMetaDataToken succeeded.");
        return ecsResult.content;
    }

    private static ECSResult executeEcsRequest(String url, Map<String, String> headers, HttpMethodEnum httpMethod, String body, MediaType contentType) throws IOException, IllegalArgumentException {
        Request.Builder builder = new Request.Builder();
        builder.header("Accept", "*/*");
        headers.forEach(builder::header);
        Request request = httpMethod == HttpMethodEnum.PUT ? builder.url(url).put(RequestBody.create(body, contentType)).build() : builder.url(url).get().build();
        Call c = httpClient.newCall(request);
        try (Response res = c.execute();){
            String header = "";
            String content = "";
            if (res.headers() != null) {
                header = res.headers().toString();
            }
            if (res.body() != null) {
                content = res.body().string();
            }
            ECSResult eCSResult = new ECSResult(res.code(), header, content);
            return eCSResult;
        }
    }

    private static class ECSResult {
        public final int code;
        public final String header;
        public final String content;

        public ECSResult(int code, String header, String content) {
            this.code = code;
            this.header = header;
            this.content = content;
        }

        public String toString() {
            return " Code : " + this.code + "; Headers : " + this.header + "; Content : " + this.content;
        }
    }
}

