/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.HeaderResponse;
import com.obs.services.model.Multipart;
import com.obs.services.model.Owner;
import com.obs.services.model.StorageClassEnum;
import java.util.ArrayList;
import java.util.List;

public class ListPartsResult
extends HeaderResponse {
    private String bucket;
    private String key;
    private String uploadId;
    private Owner initiator;
    private Owner owner;
    private StorageClassEnum storageClass;
    private List<Multipart> multipartList;
    private Integer maxParts;
    private boolean isTruncated;
    private String partNumberMarker;
    private String nextPartNumberMarker;

    @Deprecated
    public ListPartsResult(String bucket, String key, String uploadId, Owner initiator, Owner owner, StorageClassEnum storageClass, List<Multipart> multipartList, Integer maxParts, boolean isTruncated, String partNumberMarker, String nextPartNumberMarker) {
        this.bucket = bucket;
        this.key = key;
        this.uploadId = uploadId;
        this.initiator = initiator;
        this.owner = owner;
        this.storageClass = storageClass;
        this.multipartList = multipartList;
        this.maxParts = maxParts;
        this.isTruncated = isTruncated;
        this.partNumberMarker = partNumberMarker;
        this.nextPartNumberMarker = nextPartNumberMarker;
    }

    private ListPartsResult(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.initiator = builder.initiator;
        this.owner = builder.owner;
        this.storageClass = builder.storageClass;
        this.multipartList = builder.multipartList;
        this.maxParts = builder.maxParts;
        this.isTruncated = builder.isTruncated;
        this.partNumberMarker = builder.partNumberMarker;
        this.nextPartNumberMarker = builder.nextPartNumberMarker;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public Owner getInitiator() {
        return this.initiator;
    }

    public Owner getOwner() {
        return this.owner;
    }

    @Deprecated
    public String getStorageClass() {
        return this.storageClass == null ? null : this.storageClass.getCode();
    }

    public StorageClassEnum getObjectStorageClass() {
        return this.storageClass;
    }

    public Integer getMaxParts() {
        return this.maxParts;
    }

    public List<Multipart> getMultipartList() {
        if (this.multipartList == null) {
            this.multipartList = new ArrayList<Multipart>();
        }
        return this.multipartList;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public String getPartNumberMarker() {
        return this.partNumberMarker;
    }

    public String getNextPartNumberMarker() {
        return this.nextPartNumberMarker;
    }

    @Override
    public String toString() {
        return "ListPartsResult [bucket=" + this.bucket + ", key=" + this.key + ", uploadId=" + this.uploadId + ", initiator=" + this.initiator + ", owner=" + this.owner + ", storageClass=" + (Object)((Object)this.storageClass) + ", multipartList=" + this.multipartList + ", maxParts=" + this.maxParts + ", isTruncated=" + this.isTruncated + ", partNumberMarker=" + this.partNumberMarker + ", nextPartNumberMarker=" + this.nextPartNumberMarker + "]";
    }

    public static final class Builder {
        private String bucket;
        private String key;
        private String uploadId;
        private Owner initiator;
        private Owner owner;
        private StorageClassEnum storageClass;
        private List<Multipart> multipartList;
        private Integer maxParts;
        private boolean isTruncated;
        private String partNumberMarker;
        private String nextPartNumberMarker;

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public Builder initiator(Owner initiator) {
            this.initiator = initiator;
            return this;
        }

        public Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public Builder storageClass(StorageClassEnum storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder multipartList(List<Multipart> multipartList) {
            this.multipartList = multipartList;
            return this;
        }

        public Builder maxParts(Integer maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        public Builder isTruncated(boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public Builder partNumberMarker(String partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        public Builder nextPartNumberMarker(String nextPartNumberMarker) {
            this.nextPartNumberMarker = nextPartNumberMarker;
            return this;
        }

        public ListPartsResult builder() {
            return new ListPartsResult(this);
        }
    }
}

