/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.crypto;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.AbstractClient;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.crypto.CTRCipherGenerator;
import com.obs.services.crypto.CtrRSACipherGenerator;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.SimpleProgressManager;
import com.obs.services.internal.io.ProgressInputStream;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.fs.ObsFSAttribute;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.ReadFileResult;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import shade.okhttp3.Response;

public class CryptoObsClient
extends ObsClient {
    private CTRCipherGenerator ctrCipherGenerator;
    private static final ILogger log = LoggerBuilder.getLogger(CryptoObsClient.class);

    public CryptoObsClient(String endPoint, CTRCipherGenerator ctrCipherGenerator) {
        super(endPoint);
        this.ctrCipherGenerator = ctrCipherGenerator;
    }

    public CryptoObsClient(ObsConfiguration config, CTRCipherGenerator ctrCipherGenerator) {
        super(config);
        this.ctrCipherGenerator = ctrCipherGenerator;
    }

    public CryptoObsClient(String accessKey, String secretKey, String endPoint, CTRCipherGenerator ctrCipherGenerator) {
        super(accessKey, secretKey, endPoint);
        this.ctrCipherGenerator = ctrCipherGenerator;
    }

    public CryptoObsClient(String accessKey, String secretKey, ObsConfiguration config, CTRCipherGenerator ctrCipherGenerator) {
        super(accessKey, secretKey, config);
        this.ctrCipherGenerator = ctrCipherGenerator;
    }

    public CryptoObsClient(String accessKey, String secretKey, String securityToken, String endPoint, CTRCipherGenerator ctrCipherGenerator) {
        super(accessKey, secretKey, securityToken, endPoint);
        this.ctrCipherGenerator = ctrCipherGenerator;
    }

    public CryptoObsClient(String accessKey, String secretKey, String securityToken, ObsConfiguration config, CTRCipherGenerator ctrCipherGenerator) {
        super(accessKey, secretKey, securityToken, config);
        this.ctrCipherGenerator = ctrCipherGenerator;
    }

    public CryptoObsClient(IObsCredentialsProvider provider, String endPoint, CTRCipherGenerator ctrCipherGenerator) {
        super(provider, endPoint);
        this.ctrCipherGenerator = ctrCipherGenerator;
    }

    public CryptoObsClient(IObsCredentialsProvider provider, ObsConfiguration config, CTRCipherGenerator ctrCipherGenerator) {
        super(provider, config);
        this.ctrCipherGenerator = ctrCipherGenerator;
    }

    @Override
    public PutObjectResult putObject(final PutObjectRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "PutObjectRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("putObject", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<PutObjectResult>(){

            @Override
            public PutObjectResult action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return CryptoObsClient.this.putObjectImpl(request);
            }
        });
    }

    @Override
    protected ObsFSFile putObjectImpl(PutObjectRequest request) throws ServiceException {
        Response response;
        boolean isExtraAclPutRequired;
        AbstractRequestConvertor.TransResult result = null;
        AccessControlList acl = request.getAcl();
        if (request.getMetadata() == null) {
            request.setMetadata(new ObjectMetadata());
        }
        try {
            if (this.ctrCipherGenerator != null) {
                byte[] object_CryptoIvBytes = this.getOrGenerateCryptoIvBytes();
                byte[] object_CryptoKeyBytes = this.getOrGenerateCryptoKeyBytes();
                if (request.getFile() != null && this.ctrCipherGenerator.isNeedSha256()) {
                    request.getMetadata().addUserMetadata("plaintext-content-length", String.valueOf(request.getFile().length()));
                    try (FileInputStream fileInputStream = new FileInputStream(request.getFile());){
                        String content_sha256_header = "x-obs-content-sha256";
                        if (request.getUserHeaders().containsKey(content_sha256_header)) {
                            request.getMetadata().addUserMetadata("plaintext-sha256", request.getUserHeaders().get(content_sha256_header));
                            CTRCipherGenerator.SHA256Info sha256Info = this.ctrCipherGenerator.computeSHA256HashAES(fileInputStream, object_CryptoIvBytes, object_CryptoKeyBytes, false);
                            request.getMetadata().addUserMetadata("encrypted-sha256", sha256Info.getSha256ForAESEncrypted());
                            request.addUserHeaders(content_sha256_header, sha256Info.getSha256ForAESEncrypted());
                        } else {
                            CTRCipherGenerator.SHA256Info sha256Info = this.ctrCipherGenerator.computeSHA256HashAES(fileInputStream, object_CryptoIvBytes, object_CryptoKeyBytes, true);
                            request.getMetadata().addUserMetadata("plaintext-sha256", sha256Info.getSha256ForPlainText());
                            request.getMetadata().addUserMetadata("encrypted-sha256", sha256Info.getSha256ForAESEncrypted());
                            request.addUserHeaders(content_sha256_header, sha256Info.getSha256ForAESEncrypted());
                        }
                        request.setInput(new FileInputStream(request.getFile()));
                    }
                    catch (FileNotFoundException e) {
                        throw new IllegalArgumentException("File doesn't exist");
                    }
                    catch (IOException e) {
                        throw new ServiceException(e);
                    }
                }
                request.setInput(this.ctrCipherGenerator.getAES256EncryptedStream(request.getInput(), object_CryptoIvBytes, object_CryptoKeyBytes));
                ObjectMetadata objectMetadata = request.getMetadata();
                objectMetadata.addUserMetadata("encrypted-start", CTRCipherGenerator.getBase64Info(object_CryptoIvBytes));
                if (this.ctrCipherGenerator.getMasterKeyInfo() != null) {
                    objectMetadata.addUserMetadata("master-key-info", this.ctrCipherGenerator.getMasterKeyInfo());
                }
                if (this.ctrCipherGenerator instanceof CtrRSACipherGenerator) {
                    objectMetadata.addUserMetadata("encrypted-algorithm", "AES256-Ctr/iv_base64/NoPadding RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
                    CtrRSACipherGenerator ctrRSACipherGenerator = (CtrRSACipherGenerator)this.ctrCipherGenerator;
                    byte[] rsaEncryptedAESKey = ctrRSACipherGenerator.RSAEncrypted(object_CryptoKeyBytes);
                    objectMetadata.addUserMetadata("encrypted-object-key", ServiceUtils.toBase64(rsaEncryptedAESKey));
                } else {
                    objectMetadata.addUserMetadata("encrypted-algorithm", "AES256-Ctr/iv_base64/NoPadding");
                }
            }
            result = this.transPutObjectRequest(request);
            boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), acl);
            if (request.getCallback() != null) {
                ServiceUtils.assertParameterNotNull(request.getCallback().getCallbackUrl(), "callbackUrl is null");
                ServiceUtils.assertParameterNotNull(request.getCallback().getCallbackBody(), "callbackBody is null");
                result.getHeaders().put((this.getProviderCredentials().getLocalAuthType(request.getBucketName()) != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "callback", ServiceUtils.toBase64(JSONChange.objToJson(request.getCallback()).getBytes(StandardCharsets.UTF_8)));
            }
            NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
            response = this.performRequest(newTransResult, true, false, false, false);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new ServiceException(e);
        }
        finally {
            if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                ServiceUtils.closeStream((Closeable)((Object)result.getBody()));
            }
        }
        ObsFSFile ret = new ObsFSFile(request.getBucketName(), request.getObjectKey(), response.header("ETag"), response.header(this.getIHeaders(request.getBucketName()).versionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders(request.getBucketName()).storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey(), request.getIsIgnorePort()));
        if (request.getCallback() != null) {
            try {
                ret.setCallbackResponseBody(Objects.requireNonNull(response.body()).byteStream());
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
        }
        this.setHeadersAndStatus(ret, response);
        if (isExtraAclPutRequired && acl != null) {
            try {
                this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
            }
            catch (Exception e) {
                log.warn("Try to set object acl error", e);
            }
        }
        return ret;
    }

    @Override
    public ObsObject getObject(final GetObjectRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "GetObjectRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("getObject", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ObsObject>(){

            @Override
            public ObsObject action() throws ServiceException {
                return CryptoObsClient.this.getObjectImpl(request);
            }
        });
    }

    @Override
    protected ObsObject getObjectImpl(GetObjectRequest request) throws ServiceException {
        int readBufferSize;
        AbstractRequestConvertor.TransResult result = this.transGetObjectRequest(request);
        if (request.getRequestParameters() != null) {
            result.getParams().putAll(request.getRequestParameters());
        }
        Response response = this.performRestGet(request.getBucketName(), request.getObjectKey(), result.getParams(), result.getHeaders(), request.getUserHeaders(), false, request.isEncodeHeaders());
        ObsFSAttribute objMetadata = this.getObsFSAttributeFromResponse(request.getBucketName(), response, request.isEncodeHeaders());
        ReadFileResult obsObject = new ReadFileResult();
        obsObject.setObjectKey(request.getObjectKey());
        obsObject.setBucketName(request.getBucketName());
        obsObject.setMetadata(objMetadata);
        if (this.ctrCipherGenerator != null) {
            String headerMetaPrefix = this.getProviderCredentials() != null && this.getProviderCredentials().getLocalAuthType(request.getBucketName()) != AuthTypeEnum.OBS ? "x-amz-meta-" : "x-obs-meta-";
            String encryptedAlgorithm = (String)objMetadata.getOriginalHeaders().get(headerMetaPrefix + "encrypted-algorithm");
            String encryptedStart = (String)objMetadata.getOriginalHeaders().get(headerMetaPrefix + "encrypted-start");
            if (this.isValidEncryptedAlgorithm(encryptedAlgorithm)) {
                byte[] cryptoKeyBytes = this.ctrCipherGenerator.getCryptoKeyBytes();
                if (encryptedAlgorithm.equals("AES256-Ctr/iv_base64/NoPadding RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING")) {
                    if (!(this.ctrCipherGenerator instanceof CtrRSACipherGenerator)) {
                        throw new ServiceException("wrong CipherGenerator ,need " + CtrRSACipherGenerator.class.getSimpleName());
                    }
                    try {
                        CtrRSACipherGenerator ctrRSACipherGenerator = (CtrRSACipherGenerator)this.ctrCipherGenerator;
                        String aesEncryptedKey = (String)objMetadata.getOriginalHeaders().get(headerMetaPrefix + "encrypted-object-key");
                        cryptoKeyBytes = ctrRSACipherGenerator.RSADecrypted(ServiceUtils.fromBase64(aesEncryptedKey));
                    }
                    catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                        throw new ServiceException(e);
                    }
                }
                try {
                    byte[] iv = CTRCipherGenerator.getBytesFromBase64(encryptedStart);
                    obsObject.setObjectContent(this.ctrCipherGenerator.getAES256DecryptedStream(response.body().byteStream(), iv, cryptoKeyBytes));
                }
                catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
                    throw new ServiceException(e);
                }
            }
            log.warn("no encrypted-algorithm metadata received");
            obsObject.setObjectContent(response.body().byteStream());
        } else {
            log.warn("CipherGenerator is null");
            obsObject.setObjectContent(response.body().byteStream());
        }
        if (request.getProgressListener() != null) {
            SimpleProgressManager progressManager = new SimpleProgressManager(objMetadata.getContentLength(), 0L, request.getProgressListener(), request.getProgressInterval() > 0L ? request.getProgressInterval() : 102400L);
            obsObject.setObjectContent(new ProgressInputStream(obsObject.getObjectContent(), progressManager));
        }
        if ((readBufferSize = this.obsProperties.getIntProperty("httpclient.read-buffer-size", 8192)) > 0) {
            obsObject.setObjectContent(new BufferedInputStream(obsObject.getObjectContent(), readBufferSize));
        }
        return obsObject;
    }

    public boolean isValidEncryptedAlgorithm(String encryptedAlgorithm) {
        return encryptedAlgorithm != null && (encryptedAlgorithm.equals("AES256-Ctr/iv_base64/NoPadding RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING") || encryptedAlgorithm.equals("AES256-Ctr/iv_base64/NoPadding"));
    }

    protected byte[] getOrGenerateCryptoIvBytes() {
        if (this.ctrCipherGenerator.getCryptoIvBytes() != null) {
            log.info("get user-set AES iv");
            return this.ctrCipherGenerator.getCryptoIvBytes();
        }
        log.info("get random AES iv");
        return this.ctrCipherGenerator.getRandomCryptoIvBytes();
    }

    protected byte[] getOrGenerateCryptoKeyBytes() {
        if (this.ctrCipherGenerator.getCryptoKeyBytes() != null) {
            log.info("get user-set AES key");
            return this.ctrCipherGenerator.getCryptoKeyBytes();
        }
        log.info("get random AES key");
        return this.ctrCipherGenerator.getRandomCryptoKeyBytes();
    }

    public CTRCipherGenerator getCtrCipherGenerator() {
        return this.ctrCipherGenerator;
    }

    public void setCtrCipherGenerator(CTRCipherGenerator ctrCipherGenerator) {
        this.ctrCipherGenerator = ctrCipherGenerator;
    }
}

