/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.ml.scan;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.hmsscankit.DetailRect;
import com.huawei.hms.ml.scan.HmsScanAnalyzerOptions;

public abstract class HmsScanBase
implements Parcelable {
    public static final String SCAN_FORMAT_FLAG = "ScanFormatValue";
    public static final String SCAN_VIEW_FLAG = "ScanViewValue";
    public static final String SCAN_ERROR_CHECK_FLAG = "ScanErrorCheck";
    public static final String SCAN_GUIDE_FLAG = "ScanGuide";
    public static final int FORMAT_UNKNOWN = SCAN_TYPE.FORMAT_UNKNOWN.getUnKnown();
    public static final int ALL_SCAN_TYPE = 8191;
    public static final int QRCODE_SCAN_TYPE = SCAN_TYPE.QRCODE_SCAN_TYPE.getScanType();
    public static final int AZTEC_SCAN_TYPE = SCAN_TYPE.AZTEC_SCAN_TYPE.getScanType();
    public static final int DATAMATRIX_SCAN_TYPE = SCAN_TYPE.DATAMATRIX_SCAN_TYPE.getScanType();
    public static final int PDF417_SCAN_TYPE = SCAN_TYPE.PDF417_SCAN_TYPE.getScanType();
    public static final int CODE39_SCAN_TYPE = SCAN_TYPE.CODE39_SCAN_TYPE.getScanType();
    public static final int CODE93_SCAN_TYPE = SCAN_TYPE.CODE93_SCAN_TYPE.getScanType();
    public static final int CODE128_SCAN_TYPE = SCAN_TYPE.CODE128_SCAN_TYPE.getScanType();
    public static final int EAN13_SCAN_TYPE = SCAN_TYPE.EAN13_SCAN_TYPE.getScanType();
    public static final int EAN8_SCAN_TYPE = SCAN_TYPE.EAN8_SCAN_TYPE.getScanType();
    public static final int ITF14_SCAN_TYPE = SCAN_TYPE.ITF14_SCAN_TYPE.getScanType();
    public static final int UPCCODE_A_SCAN_TYPE = SCAN_TYPE.UPCCODE_A_SCAN_TYPE.getScanType();
    public static final int UPCCODE_E_SCAN_TYPE = SCAN_TYPE.UPCCODE_E_SCAN_TYPE.getScanType();
    public static final int CODABAR_SCAN_TYPE = SCAN_TYPE.CODABAR_SCAN_TYPE.getScanType();
    public static final int MULTI_FUNCTIONAL_SCAN_TYPE = SCAN_TYPE.MULTI_FUNCTIONAL_SCAN_TYPE.getScanType();
    public static final int WX_SCAN_TYPE = SCAN_TYPE.WX_SCAN_TYPE.getScanType();
    public static final int OTHER_FORM = -1;
    private int HMS_SCAN_VERSION = 3;
    public int scanTypeForm;
    public Point[] cornerPoints;
    public String showResult;
    public int scanType;
    public double zoomValue;
    public byte[] originValueByte;
    public String originalValue;
    public HmsScanAnalyzerOptions options;
    public Bitmap originalBitmap;

    public HmsScanBase() {
    }

    public HmsScanBase(String string2, int n9, String string3, int n10, byte[] byArray, Point[] pointArray, HmsScanAnalyzerOptions hmsScanAnalyzerOptions) {
        this.originalValue = string2;
        this.scanType = n9;
        this.showResult = string3;
        this.scanTypeForm = n10;
        this.originValueByte = byArray;
        this.cornerPoints = pointArray;
        this.options = hmsScanAnalyzerOptions;
    }

    protected HmsScanBase(Parcel parcel) {
        this.HMS_SCAN_VERSION = parcel.readInt();
        if (this.HMS_SCAN_VERSION >= 1) {
            this.scanType = parcel.readInt();
            this.originalValue = parcel.readString();
            this.scanTypeForm = parcel.readInt();
            this.showResult = parcel.readString();
            this.cornerPoints = (Point[])parcel.createTypedArray(Point.CREATOR);
            this.zoomValue = parcel.readDouble();
            this.originValueByte = parcel.createByteArray();
            this.detailTrans(parcel);
        }
        if (this.HMS_SCAN_VERSION >= 3) {
            this.originalBitmap = (Bitmap)parcel.readParcelable(Bitmap.class.getClassLoader());
        }
    }

    public int getScanTypeForm() {
        return this.scanTypeForm;
    }

    public double getZoomValue() {
        return this.zoomValue;
    }

    public byte[] getOriginValueByte() {
        return this.originValueByte;
    }

    public Bitmap getOriginalBitmap() {
        return this.originalBitmap;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public Rect getBorderRect() {
        int n9 = Integer.MAX_VALUE;
        int n10 = Integer.MAX_VALUE;
        int n11 = Integer.MIN_VALUE;
        int n12 = Integer.MIN_VALUE;
        int n13 = 0;
        while (true) {
            Point[] pointArray = this.cornerPoints;
            if (n13 >= this.cornerPoints.length) break;
            int n14 = n12;
            int n15 = n11;
            int n16 = n10;
            Point point = pointArray[n13];
            n10 = Math.min(n9, point.x);
            n11 = Math.min(n16, point.y);
            n12 = Math.max(n15, point.x);
            n9 = Math.max(n14, point.y);
            ++n13;
            int n17 = n10;
            int n18 = n11;
            int n19 = n12;
            n12 = n9;
            n11 = n19;
            n10 = n18;
            n9 = n17;
        }
        return new Rect(n9, n10, n11, n12);
    }

    public Point[] getCornerPoints() {
        return this.cornerPoints;
    }

    public String getShowResult() {
        return this.showResult;
    }

    public int getScanType() {
        return this.scanType;
    }

    protected abstract void detailTrans(Parcel var1);

    protected abstract void detailTransOut(Parcel var1, int var2);

    public void writeToParcel(Parcel parcel, int n9) {
        Parcel parcel2 = parcel;
        parcel.writeInt(this.HMS_SCAN_VERSION);
        parcel.writeInt(this.scanType);
        parcel.writeString(this.originalValue);
        parcel.writeInt(this.scanTypeForm);
        parcel.writeString(this.showResult);
        parcel.writeTypedArray((Parcelable[])this.cornerPoints, n9);
        parcel.writeDouble(this.zoomValue);
        parcel2.writeByteArray(this.originValueByte);
        this.detailTransOut(parcel2, n9);
        if (DetailRect.HMSSCAN_SDK_VALUE >= 3) {
            parcel.writeParcelable((Parcelable)this.originalBitmap, n9);
        }
    }

    public int describeContents() {
        return 0;
    }

    static final class SCAN_TYPE
    extends Enum<SCAN_TYPE> {
        public static final /* enum */ SCAN_TYPE FORMAT_UNKNOWN;
        public static final /* enum */ SCAN_TYPE ALL_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE QRCODE_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE AZTEC_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE DATAMATRIX_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE PDF417_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE CODE39_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE CODE93_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE CODE128_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE EAN13_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE EAN8_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE ITF14_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE UPCCODE_A_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE UPCCODE_E_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE CODABAR_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE MULTI_FUNCTIONAL_SCAN_TYPE;
        public static final /* enum */ SCAN_TYPE WX_SCAN_TYPE;
        private static final /* synthetic */ SCAN_TYPE[] $VALUES;
        private final int scanType;

        public static SCAN_TYPE[] values() {
            return (SCAN_TYPE[])$VALUES.clone();
        }

        public static SCAN_TYPE valueOf(String string2) {
            return Enum.valueOf(SCAN_TYPE.class, string2);
        }

        private SCAN_TYPE(int n10) {
            this.scanType = n10;
        }

        static {
            SCAN_TYPE sCAN_TYPE;
            SCAN_TYPE sCAN_TYPE2;
            SCAN_TYPE sCAN_TYPE3;
            SCAN_TYPE sCAN_TYPE4;
            SCAN_TYPE sCAN_TYPE5;
            SCAN_TYPE sCAN_TYPE6;
            SCAN_TYPE sCAN_TYPE7;
            SCAN_TYPE sCAN_TYPE8;
            SCAN_TYPE sCAN_TYPE9;
            SCAN_TYPE sCAN_TYPE10;
            SCAN_TYPE sCAN_TYPE11;
            SCAN_TYPE sCAN_TYPE12;
            SCAN_TYPE sCAN_TYPE13;
            SCAN_TYPE sCAN_TYPE14;
            SCAN_TYPE sCAN_TYPE15;
            SCAN_TYPE sCAN_TYPE16;
            SCAN_TYPE sCAN_TYPE17;
            SCAN_TYPE sCAN_TYPE18 = sCAN_TYPE17;
            FORMAT_UNKNOWN = new SCAN_TYPE(-1);
            SCAN_TYPE sCAN_TYPE19 = sCAN_TYPE16;
            ALL_SCAN_TYPE = new SCAN_TYPE(0);
            SCAN_TYPE sCAN_TYPE20 = sCAN_TYPE15;
            QRCODE_SCAN_TYPE = new SCAN_TYPE(0);
            SCAN_TYPE sCAN_TYPE21 = sCAN_TYPE14;
            AZTEC_SCAN_TYPE = new SCAN_TYPE(1);
            SCAN_TYPE sCAN_TYPE22 = sCAN_TYPE13;
            DATAMATRIX_SCAN_TYPE = new SCAN_TYPE(2);
            SCAN_TYPE sCAN_TYPE23 = sCAN_TYPE12;
            PDF417_SCAN_TYPE = new SCAN_TYPE(3);
            SCAN_TYPE sCAN_TYPE24 = sCAN_TYPE11;
            CODE39_SCAN_TYPE = new SCAN_TYPE(4);
            SCAN_TYPE sCAN_TYPE25 = sCAN_TYPE10;
            CODE93_SCAN_TYPE = new SCAN_TYPE(5);
            SCAN_TYPE sCAN_TYPE26 = sCAN_TYPE9;
            CODE128_SCAN_TYPE = new SCAN_TYPE(6);
            SCAN_TYPE sCAN_TYPE27 = sCAN_TYPE8;
            EAN13_SCAN_TYPE = new SCAN_TYPE(7);
            SCAN_TYPE sCAN_TYPE28 = sCAN_TYPE7;
            EAN8_SCAN_TYPE = new SCAN_TYPE(8);
            SCAN_TYPE sCAN_TYPE29 = sCAN_TYPE6;
            ITF14_SCAN_TYPE = new SCAN_TYPE(9);
            SCAN_TYPE sCAN_TYPE30 = sCAN_TYPE5;
            UPCCODE_A_SCAN_TYPE = new SCAN_TYPE(10);
            SCAN_TYPE sCAN_TYPE31 = sCAN_TYPE4;
            UPCCODE_E_SCAN_TYPE = new SCAN_TYPE(11);
            SCAN_TYPE sCAN_TYPE32 = sCAN_TYPE3;
            CODABAR_SCAN_TYPE = new SCAN_TYPE(12);
            SCAN_TYPE sCAN_TYPE33 = sCAN_TYPE2;
            MULTI_FUNCTIONAL_SCAN_TYPE = new SCAN_TYPE(13);
            SCAN_TYPE sCAN_TYPE34 = sCAN_TYPE;
            WX_SCAN_TYPE = new SCAN_TYPE(14);
            $VALUES = new SCAN_TYPE[]{sCAN_TYPE18, sCAN_TYPE19, sCAN_TYPE20, sCAN_TYPE21, sCAN_TYPE22, sCAN_TYPE23, sCAN_TYPE24, sCAN_TYPE25, sCAN_TYPE26, sCAN_TYPE27, sCAN_TYPE28, sCAN_TYPE29, sCAN_TYPE30, sCAN_TYPE31, sCAN_TYPE32, sCAN_TYPE33, sCAN_TYPE34};
        }

        int getScanType() {
            return 1 << this.scanType;
        }

        int getUnKnown() {
            return this.scanType;
        }
    }
}

