/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.ml.scan;

import android.content.Context;
import android.text.TextUtils;
import android.util.SparseArray;
import com.huawei.agconnect.AGConnectInstance;
import com.huawei.hmf.tasks.Task;
import com.huawei.hmf.tasks.Tasks;
import com.huawei.hms.hmsscankit.ScanUtil;
import com.huawei.hms.ml.scan.HmsScan;
import com.huawei.hms.ml.scan.HmsScanAnalyzerOptions;
import com.huawei.hms.mlsdk.common.MLAnalyzer;
import com.huawei.hms.mlsdk.common.MLFrame;
import com.huawei.hms.scankit.p.o4;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class HmsScanAnalyzer
extends MLAnalyzer<HmsScan> {
    private static final String TAG = "HmsScanAnalyzer";
    private Context mContext;
    private HmsScanAnalyzerOptions mlVisionScanDetectorOptions;

    public HmsScanAnalyzer(HmsScanAnalyzerOptions hmsScanAnalyzerOptions) {
        this.mContext = AGConnectInstance.getInstance().getContext();
        this.mlVisionScanDetectorOptions = hmsScanAnalyzerOptions;
    }

    public HmsScanAnalyzer() {
        if (AGConnectInstance.getInstance() != null) {
            this.mContext = AGConnectInstance.getInstance().getContext();
        } else {
            o4.e(TAG, "AGConnectInstanceImpl contect is null");
        }
    }

    private HmsScanAnalyzer(Context context, HmsScanAnalyzerOptions hmsScanAnalyzerOptions) {
        this.mContext = context;
        this.mlVisionScanDetectorOptions = hmsScanAnalyzerOptions;
    }

    public SparseArray<HmsScan> analyseFrame(MLFrame mLFrame) {
        SparseArray sparseArray;
        o4.b("scankit mul", "start analyseFrame");
        if (mLFrame == null) {
            return new SparseArray();
        }
        HmsScan[] hmsScanArray = ScanUtil.detectForHmsDector(hmsScanArray.mContext, mLFrame, hmsScanArray.mlVisionScanDetectorOptions);
        o4.b("scankit mul", "analyseFrame end");
        mLFrame = sparseArray;
        sparseArray = new SparseArray();
        for (int i9 = 0; i9 < hmsScanArray.length; ++i9) {
            HmsScan hmsScan = hmsScanArray[i9];
            if (hmsScan == null || TextUtils.isEmpty((CharSequence)hmsScan.originalValue)) continue;
            mLFrame.append(hmsScan.originalValue.hashCode(), (Object)hmsScan);
        }
        return mLFrame;
    }

    public boolean isAvailable() {
        return ScanUtil.isScanAvailable(this.mContext);
    }

    public void destory() throws IOException {
        super.destroy();
    }

    public Task<List<HmsScan>> analyzInAsyn(final MLFrame mLFrame) {
        return Tasks.callInBackground((Callable)new Callable<List<HmsScan>>(){

            @Override
            public List<HmsScan> call() throws Exception {
                ArrayList<HmsScan> arrayList;
                if (hmsScanArray.mLFrame == null) {
                    return null;
                }
                HmsScan[] hmsScanArray = ScanUtil.detectForHmsDector(hmsScanArray.HmsScanAnalyzer.this.mContext, hmsScanArray.mLFrame, hmsScanArray.HmsScanAnalyzer.this.mlVisionScanDetectorOptions);
                ArrayList<HmsScan> arrayList2 = arrayList;
                arrayList = new ArrayList<HmsScan>();
                for (HmsScan hmsScan : hmsScanArray) {
                    if (hmsScan == null || TextUtils.isEmpty((CharSequence)hmsScan.originalValue)) continue;
                    arrayList2.add(hmsScan);
                }
                return arrayList2;
            }
        });
    }

    public static class Creator {
        private Context mContext;
        private HmsScanAnalyzerOptions mOptions;

        public Creator(Context context) {
            this.mContext = context;
        }

        public Creator() {
            this.mContext = AGConnectInstance.getInstance().getContext();
        }

        public HmsScanAnalyzer create() {
            Creator creator = this;
            Context context = creator.mContext;
            HmsScanAnalyzerOptions hmsScanAnalyzerOptions = creator.mOptions;
            if (hmsScanAnalyzerOptions == null) {
                hmsScanAnalyzerOptions = new HmsScanAnalyzerOptions.Creator().setHmsScanTypes(0, new int[0]).create();
            }
            Object object = this;
            ((HmsScanAnalyzer)((Object)object))(context, hmsScanAnalyzerOptions);
            return object;
        }

        public Creator setHmsScanTypes(int n9, int ... nArray) {
            this.mOptions = new HmsScanAnalyzerOptions.Creator().setHmsScanTypes(n9, nArray).create();
            return this;
        }

        public Creator setHmsScanTypes(HmsScanAnalyzerOptions hmsScanAnalyzerOptions) {
            this.mOptions = hmsScanAnalyzerOptions == null ? new HmsScanAnalyzerOptions.Creator().setHmsScanTypes(0, new int[0]).create() : hmsScanAnalyzerOptions;
            return this;
        }
    }
}

