/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.annotation.SuppressLint;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.PowerManager;
import com.huawei.hms.framework.common.ContextCompat;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.SettingUtil;

public class PowerUtils {
    private static final String TAG = "PowerUtils";

    public static boolean isInteractive(Context context) {
        Object object;
        boolean isInteractive = false;
        if (context != null && (object = ContextCompat.getSystemService(context, "power")) instanceof PowerManager) {
            PowerManager powerManager = (PowerManager)object;
            if (Build.VERSION.SDK_INT >= 20) {
                try {
                    isInteractive = powerManager.isInteractive();
                }
                catch (RuntimeException e) {
                    Logger.i((String)TAG, (Object)("getActiveNetworkInfo failed, exception:" + e.getClass().getSimpleName() + e.getMessage()));
                }
            }
        }
        return isInteractive;
    }

    public static int readPowerSaverMode(Context context) {
        int powerSaverMode;
        block10: {
            powerSaverMode = 0;
            if (context != null) {
                powerSaverMode = SettingUtil.getSystemInt(context.getContentResolver(), "SmartModeStatus", 0);
                if (powerSaverMode == 0) {
                    PowerManager powerManager = null;
                    Object object = ContextCompat.getSystemService(context, "power");
                    if (object instanceof PowerManager) {
                        powerManager = (PowerManager)object;
                    }
                    if (powerManager != null) {
                        if (Build.VERSION.SDK_INT >= 21) {
                            try {
                                boolean isPowerSaverMode = powerManager.isPowerSaveMode();
                                if (isPowerSaverMode) {
                                    powerSaverMode = 4;
                                    break block10;
                                }
                                powerSaverMode = 0;
                            }
                            catch (RuntimeException e) {
                                Logger.e((String)TAG, (String)"dealType rethrowFromSystemServer:", (Throwable)e);
                            }
                        } else {
                            Logger.i((String)TAG, (Object)"readPowerSaverMode is control by version!");
                        }
                    }
                }
            } else {
                Logger.i((String)TAG, (Object)"readPowerSaverMode Context is null!");
            }
        }
        return powerSaverMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAppIdleMode(Context context) {
        boolean isAppIdleMode = false;
        if (context != null) {
            String packetName = context.getPackageName();
            UsageStatsManager statsManager = null;
            if (Build.VERSION.SDK_INT >= 21) {
                if (Build.VERSION.SDK_INT >= 22) {
                    Object object = context.getSystemService("usagestats");
                    if (!(object instanceof UsageStatsManager)) return isAppIdleMode;
                    statsManager = (UsageStatsManager)object;
                }
            } else {
                Logger.i((String)TAG, (Object)"isAppIdleMode statsManager is null!");
            }
            if (statsManager != null) {
                if (Build.VERSION.SDK_INT < 23) return isAppIdleMode;
                return statsManager.isAppInactive(packetName);
            }
            Logger.i((String)TAG, (Object)"isAppIdleMode statsManager is null!");
            return false;
        }
        Logger.i((String)TAG, (Object)"isAppIdleMode Context is null!");
        return isAppIdleMode;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"MissingPermission"})
    public static int readDataSaverMode(Context context) {
        int dateSaverMode = 0;
        ConnectivityManager manager = null;
        if (context == null) {
            Logger.i((String)TAG, (Object)"readDataSaverMode manager is null!");
            return dateSaverMode;
        }
        Object object = context.getSystemService("connectivity");
        if (object instanceof ConnectivityManager) {
            manager = (ConnectivityManager)object;
        }
        if (manager == null) {
            Logger.i((String)TAG, (Object)"readDataSaverMode Context is null!");
            return dateSaverMode;
        }
        if (Build.VERSION.SDK_INT < 16) return dateSaverMode;
        if (ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return dateSaverMode;
        }
        if (manager.isActiveNetworkMetered()) {
            if (Build.VERSION.SDK_INT < 24) return dateSaverMode;
            return manager.getRestrictBackgroundStatus();
        }
        Logger.v((String)TAG, (Object)"ConnectType is not Mobile Network!");
        return dateSaverMode;
    }

    public static boolean isWhilteList(Context context) {
        PowerManager powerManager = null;
        boolean isAllowList = false;
        if (context != null) {
            Object object = ContextCompat.getSystemService(context, "power");
            if (object instanceof PowerManager) {
                powerManager = (PowerManager)object;
            }
            String packetName = context.getPackageName();
            if (powerManager != null && Build.VERSION.SDK_INT >= 23) {
                try {
                    isAllowList = powerManager.isIgnoringBatteryOptimizations(packetName);
                }
                catch (RuntimeException e) {
                    Logger.e((String)TAG, (String)"dealType rethrowFromSystemServer:", (Throwable)e);
                }
            }
        }
        return isAllowList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDozeIdleMode(Context context) {
        boolean isDevicemode = false;
        PowerManager powerManager = null;
        if (context == null) {
            Logger.i((String)TAG, (Object)"isDozeIdleMode Context is null!");
            return isDevicemode;
        }
        Object object = ContextCompat.getSystemService(context, "power");
        if (object instanceof PowerManager) {
            powerManager = (PowerManager)object;
        }
        if (powerManager == null) {
            Logger.i((String)TAG, (Object)"isDozeIdleMode powerManager is null!");
            return false;
        }
        if (Build.VERSION.SDK_INT < 23) {
            Logger.i((String)TAG, (Object)"isDozeIdleMode is version control state!");
            return false;
        }
        try {
            return powerManager.isDeviceIdleMode();
        }
        catch (RuntimeException e) {
            Logger.e((String)TAG, (String)"dealType rethrowFromSystemServer:", (Throwable)e);
            return isDevicemode;
        }
    }

    public static final class PowerMode {
        static final String SMART_MODE_STATUS = "SmartModeStatus";
        static final int POWER_SAVER_MODE = 4;
        static final int POWER_MODE_DEFAULT_RETURN_VALUE = 0;
    }
}

