/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PackageManagerCompat {
    private static final String TAG = "PackageUtils";
    private static final String VERSION = "7.0.2.301";
    private static String sAppVersion = "";

    public static String getAppPackageName(Context context) {
        Context appContext = ContextHolder.getAppContext() == null ? context : ContextHolder.getAppContext();
        String packageName = "";
        PackageManager packageManager = appContext.getPackageManager();
        if (packageManager == null) {
            return packageName;
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(appContext.getPackageName(), 16384);
            packageName = packageInfo.packageName;
        }
        catch (PackageManager.NameNotFoundException | RuntimeException e) {
            Logger.w((String)TAG, (Object)"Failed to get Package managers Package Info");
        }
        return packageName;
    }

    public static String getAppVersion(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sAppVersion)) {
            return sAppVersion;
        }
        Context appContext = ContextHolder.getAppContext() == null ? context : ContextHolder.getAppContext();
        PackageInfo packageInfo = null;
        PackageManager packageManager = appContext.getPackageManager();
        if (packageManager == null) {
            return sAppVersion;
        }
        try {
            packageInfo = packageManager.getPackageInfo(appContext.getPackageName(), 16384);
            sAppVersion = String.valueOf(packageInfo.versionCode);
        }
        catch (PackageManager.NameNotFoundException | RuntimeException e) {
            Logger.w((String)TAG, (Object)"Failed to get Package managers Package Info");
        }
        return sAppVersion;
    }

    private static Bundle getBundleFromApp(Context context) {
        Context appContext;
        Bundle bundle = Bundle.EMPTY;
        ApplicationInfo applicationInfo = null;
        Context context2 = appContext = ContextHolder.getAppContext() == null ? context : ContextHolder.getAppContext();
        if (appContext == null) {
            return bundle;
        }
        PackageManager packageManager = appContext.getPackageManager();
        if (packageManager == null) {
            return bundle;
        }
        try {
            applicationInfo = packageManager.getApplicationInfo(appContext.getPackageName(), 128);
            if (applicationInfo != null && applicationInfo.metaData != null) {
                bundle = applicationInfo.metaData;
            }
        }
        catch (PackageManager.NameNotFoundException | RuntimeException e) {
            Logger.w((String)TAG, (String)"NameNotFoundException:", (Throwable)e);
        }
        return bundle;
    }

    public static String getMetaDataFromApp(Context context, String key, String defaultValue) {
        Bundle bundle = PackageManagerCompat.getBundleFromApp(context);
        if (bundle != null) {
            return bundle.getString(key, defaultValue);
        }
        return defaultValue;
    }

    private static Bundle getBundleFromKit(Context context) {
        Context kitContext;
        Context context2 = kitContext = ContextHolder.getKitContext() == null ? context : ContextHolder.getKitContext();
        if (kitContext == null) {
            Logger.v((String)TAG, (Object)"the kitContext is null");
            return Bundle.EMPTY;
        }
        if (kitContext.getApplicationInfo() == null) {
            Logger.v((String)TAG, (Object)"the kit applicationInfo is null");
            return Bundle.EMPTY;
        }
        Logger.i((String)TAG, (Object)("kitContext: " + kitContext.getPackageName()));
        Bundle kitBundle = kitContext.getApplicationInfo().metaData;
        return kitBundle == null ? Bundle.EMPTY : kitBundle;
    }

    public static String getMetaDataFromKit(Context context, String key, String defaultValue) {
        try {
            Bundle kitBundle = PackageManagerCompat.getBundleFromKit(context);
            if (kitBundle == null) {
                return defaultValue;
            }
            return kitBundle.getString(key, defaultValue);
        }
        catch (RuntimeException runtimeException) {
            Logger.v((String)TAG, (Object)"the kit metaData is runtimeException");
            return defaultValue;
        }
    }

    private static Bundle getBundleFromKitOrAPP(Context context) {
        Bundle resourceBundle = PackageManagerCompat.getBundleFromKit(context);
        if (resourceBundle == null || resourceBundle.isEmpty()) {
            resourceBundle = PackageManagerCompat.getBundleFromApp(context);
        }
        return resourceBundle;
    }

    public static String getMetaDataFromKitOrApp(Context context, String key, String defaultValue) {
        return PackageManagerCompat.getBundleFromKitOrAPP(context).getString(key, defaultValue);
    }

    public static Map<String, String> getMetaDataMapFromKitOrApp(Context context, String prefixForKey) {
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        Bundle resourceBundle = PackageManagerCompat.getBundleFromKitOrAPP(context);
        Set metaDataKeySet = resourceBundle.keySet();
        for (String key : metaDataKeySet) {
            String value;
            if (!key.startsWith(prefixForKey) || TextUtils.isEmpty((CharSequence)(value = resourceBundle.getString(key)))) continue;
            metaDataMap.put(key.substring(prefixForKey.length()), value);
        }
        return metaDataMap;
    }
}

