/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.hms.framework.common.ContextCompat;
import com.huawei.hms.framework.common.EmuiUtil;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.ReflectionUtils;
import com.huawei.libcore.io.ExternalStorageFile;
import com.huawei.libcore.io.ExternalStorageFileInputStream;
import com.huawei.libcore.io.ExternalStorageFileOutputStream;
import com.huawei.libcore.io.ExternalStorageRandomAccessFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CreateFileUtil {
    private static final String TAG = "CreateFileUtil";
    private static final String EXTERNAL_FILE_NAME = "com.huawei.libcore.io.ExternalStorageFile";
    private static final String EXTERNAL_INPUTSTREAM_NAME = "com.huawei.libcore.io.ExternalStorageFileInputStream";
    private static final String EXTERNAL_OUTPUTSTREAM_NAME = "com.huawei.libcore.io.ExternalStorageFileOutputStream";
    private static final String RANDOM_ACCESS_FILE_NAME = "com.huawei.libcore.io.ExternalStorageRandomAccessFile";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getCacheDirPath(Context context) {
        if (context == null) {
            return "";
        }
        return ContextCompat.getProtectedStorageContext(context).getCacheDir().getPath();
    }

    public static File newFile(String path) {
        if (path == null) {
            return null;
        }
        if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible((String)EXTERNAL_FILE_NAME)) {
            return new ExternalStorageFile(path);
        }
        return new File(path);
    }

    public static File newSafeFile(String filePath) {
        if (filePath == null) {
            return null;
        }
        try {
            File file = CreateFileUtil.newFile(filePath);
            if (!file.exists()) {
                file = new File(filePath);
            }
            return file;
        }
        catch (RuntimeException runtimeException) {
            Logger.w((String)TAG, (Object)"newFile is runtimeException");
        }
        catch (Throwable throwable) {
            Logger.w((String)TAG, (Object)"newFile is Throwable");
        }
        return new File(filePath);
    }

    public static String getCanonicalPath(String path) {
        String canonicalPath = path;
        try {
            canonicalPath = CreateFileUtil.newFile(path).getCanonicalPath();
        }
        catch (IOException ex) {
            Logger.w((String)TAG, (String)"the canonicalPath has IOException", (Throwable)ex);
        }
        catch (SecurityException ex) {
            Logger.w((String)TAG, (String)"the canonicalPath has securityException", (Throwable)ex);
        }
        catch (Exception ex) {
            Logger.w((String)TAG, (String)"the canonicalPath has other Exception", (Throwable)ex);
        }
        return canonicalPath;
    }

    public static FileInputStream newFileInputStream(String path) throws FileNotFoundException {
        if (path == null) {
            Logger.w((String)TAG, (Object)"newFileInputStream  file is null");
            throw new FileNotFoundException("file is null");
        }
        if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible((String)EXTERNAL_INPUTSTREAM_NAME)) {
            return new ExternalStorageFileInputStream(path);
        }
        return new FileInputStream(path);
    }

    public static FileInputStream newSafeFileInputStream(String path) throws FileNotFoundException {
        try {
            FileInputStream fis = CreateFileUtil.newFileInputStream(path);
            return fis;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.w((String)TAG, (Object)"newFileInputStream is fileNotFoundException");
        }
        catch (RuntimeException runtimeException) {
            Logger.w((String)TAG, (Object)"newFileInputStream is runtimeException");
        }
        catch (Throwable throwable) {
            Logger.w((String)TAG, (Object)"newFileInputStream is Throwable");
        }
        return new FileInputStream(path);
    }

    public static FileOutputStream newFileOutputStream(File file) throws FileNotFoundException {
        if (file == null) {
            Logger.e((String)TAG, (Object)"newFileOutputStream  file is null");
            throw new FileNotFoundException("file is null");
        }
        if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible((String)EXTERNAL_OUTPUTSTREAM_NAME)) {
            return new ExternalStorageFileOutputStream(file);
        }
        return new FileOutputStream(file);
    }

    public static FileOutputStream newSafeFileOutputStream(File file) throws FileNotFoundException {
        try {
            FileOutputStream fos = CreateFileUtil.newFileOutputStream(file);
            return fos;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.w((String)TAG, (Object)"newFileOutputStream is fileNotFoundException");
        }
        catch (RuntimeException runtimeException) {
            Logger.w((String)TAG, (Object)"newFileOutputStream is runtimeException");
        }
        catch (Throwable throwable) {
            Logger.w((String)TAG, (Object)"newFileOutputStream is Throwable");
        }
        return new FileOutputStream(file);
    }

    public static RandomAccessFile newRandomAccessFile(String filePath, String mode) throws FileNotFoundException {
        if (filePath == null) {
            Logger.w((String)TAG, (Object)"newFileOutputStream  file is null");
            throw new FileNotFoundException("file is null");
        }
        if (EmuiUtil.isUpPVersion() && ReflectionUtils.checkCompatible((String)RANDOM_ACCESS_FILE_NAME)) {
            return new ExternalStorageRandomAccessFile(filePath, mode);
        }
        return new RandomAccessFile(filePath, mode);
    }

    public static RandomAccessFile newSafeRandomAccessFile(String filePath, String mode) throws FileNotFoundException {
        if (filePath == null) {
            Logger.w((String)TAG, (Object)"newRandomAccessFile  file is null");
            throw new FileNotFoundException("file is null");
        }
        try {
            RandomAccessFile randomAccessFile = CreateFileUtil.newRandomAccessFile(filePath, mode);
            return randomAccessFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.w((String)TAG, (Object)"newRandomAccessFile is fileNotFoundException");
        }
        catch (RuntimeException runtimeException) {
            Logger.w((String)TAG, (Object)"newRandomAccessFile is runtimeException");
        }
        catch (Throwable throwable) {
            Logger.w((String)TAG, (Object)"newRandomAccessFile is Throwable");
        }
        return new RandomAccessFile(filePath, mode);
    }

    public static void deleteSecure(File file) {
        if (file != null && file.exists() && !file.delete()) {
            Logger.w((String)TAG, (Object)"deleteSecure exception");
        }
    }

    public static void deleteSecure(String filePath) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            CreateFileUtil.deleteSecure(CreateFileUtil.newFile(filePath));
        }
    }

    @Deprecated
    public static boolean isPVersion() {
        return EmuiUtil.isUpPVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileHashData(String datafile, String checkType) {
        String hashData = null;
        FileInputStream fis = null;
        try {
            MessageDigest md = MessageDigest.getInstance(checkType);
            fis = CreateFileUtil.newSafeFileInputStream(datafile);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            long total = 0L;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
                total += (long)nread;
            }
            if (total > 0L) {
                byte[] mdbytes = md.digest();
                hashData = CreateFileUtil.byteArrayToHex(mdbytes);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.e((String)TAG, (String)"getFileHashData NoSuchAlgorithmException", (Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            Logger.e((String)TAG, (String)"getFileHashData FileNotFoundException", (Throwable)ex);
        }
        catch (IOException ex) {
            Logger.e((String)TAG, (String)"getFileHashData IOException", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.e((String)TAG, (String)"getFileHashData IllegalArgumentException", (Throwable)ex);
        }
        catch (IndexOutOfBoundsException ex) {
            Logger.e((String)TAG, (String)"getFileHashData IndexOutOfBoundsException", (Throwable)ex);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Logger.e((String)TAG, (Object)"Close FileInputStream failed!");
                }
            }
        }
        return hashData;
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte byteitem : byteArray) {
            resultCharArray[index++] = HEX_DIGITS[byteitem >>> 4 & 0xF];
            resultCharArray[index++] = HEX_DIGITS[byteitem & 0xF];
        }
        return new String(resultCharArray);
    }
}

