/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.Logger;
import java.util.ArrayList;
import java.util.List;

public class ActivityUtil {
    private static final String TAG = "ActivityUtil";
    private List<OnAppStatusListener> onAppStatusListeners = new ArrayList<OnAppStatusListener>();
    private static volatile ActivityUtil instance;
    private static final int MAX_NUM = 20;
    private boolean isForeground;
    private Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){
        private int activityStartCount = 0;

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
            ++this.activityStartCount;
            if (this.activityStartCount == 1) {
                ActivityUtil.this.isForeground = true;
                Logger.d((String)ActivityUtil.TAG, (Object)"onActivityStarted");
                for (int i = 0; i < ActivityUtil.this.onAppStatusListeners.size(); ++i) {
                    ((OnAppStatusListener)ActivityUtil.this.onAppStatusListeners.get(i)).onFront();
                }
            }
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            --this.activityStartCount;
            if (this.activityStartCount == 0) {
                Logger.d((String)ActivityUtil.TAG, (Object)"onActivityStopped");
                ActivityUtil.this.isForeground = false;
                for (int i = 0; i < ActivityUtil.this.onAppStatusListeners.size(); ++i) {
                    ((OnAppStatusListener)ActivityUtil.this.onAppStatusListeners.get(i)).onBack();
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };

    private ActivityUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityUtil getInstance() {
        if (instance != null) return instance;
        Class<ActivityUtil> clazz = ActivityUtil.class;
        synchronized (ActivityUtil.class) {
            if (instance != null) return instance;
            instance = new ActivityUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Deprecated
    public static boolean isForeground(Context context) {
        return ActivityUtil.getInstance().isForeground();
    }

    public boolean isForeground() {
        return this.isForeground;
    }

    public static PendingIntent getActivities(Context context, int requestCode, Intent[] intents, int flags) {
        if (context == null) {
            Logger.w((String)TAG, (Object)"context is null");
            return null;
        }
        PendingIntent pendingIntent = null;
        try {
            pendingIntent = PendingIntent.getActivities((Context)context, (int)requestCode, (Intent[])intents, (int)flags);
        }
        catch (RuntimeException e) {
            Logger.e((String)TAG, (String)"dealType rethrowFromSystemServer:", (Throwable)e);
        }
        return pendingIntent;
    }

    public void register() {
        Context appContext = ContextHolder.getAppContext();
        if (appContext instanceof Application) {
            Application application = (Application)appContext;
            application.registerActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
        } else {
            Logger.w((String)TAG, (Object)"context is not application, register background fail");
        }
    }

    public void unRegister() {
        Context appContext = ContextHolder.getAppContext();
        if (appContext instanceof Application) {
            Application application = (Application)appContext;
            application.unregisterActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
        } else {
            Logger.w((String)TAG, (Object)"context is not application, unRegister background fail");
        }
    }

    public void setOnAppStatusListener(OnAppStatusListener onAppStatusListener) {
        if (onAppStatusListener == null) {
            Logger.w((String)TAG, (Object)"onAppStatusListener is null");
            return;
        }
        if (this.onAppStatusListeners.size() >= 20) {
            Logger.w((String)TAG, (Object)"onAppStatusListener of count is max");
            return;
        }
        this.onAppStatusListeners.add(onAppStatusListener);
    }

    public static interface OnAppStatusListener {
        public void onFront();

        public void onBack();
    }
}

