/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common.hianalytics;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import androidx.annotation.NonNull;
import com.huawei.hianalytics.process.HiAnalyticsInstance;
import com.huawei.hianalytics.process.HiAnalyticsManager;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.ExecutorsUtils;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.StringUtils;
import com.huawei.hms.framework.common.hianalytics.CrashHianalyticsData;
import com.huawei.hms.framework.common.hianalytics.HianalyticsBaseData;
import com.huawei.hms.support.hianalytics.HiAnalyticsUtils;
import com.huawei.hms.utils.HMSBIInitializer;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public class HianalyticsHelper {
    private static final String TAG = "HianalyticsHelper";
    private static final String HWID_HA_SERVICE_TAG = "hms_hwid";
    private static final String DEAULT_HA_SERVICE_TAG = "_default_config_tag";
    private static final String USER_EXPERIENCE_INVOLVED = "user_experience_involved";
    private static final int USER_EXPERIENCE_ON = 1;
    private static final int TYPE_MAINTF = 1;
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile HianalyticsHelper instance;
    private boolean hasHianalytics;
    private boolean hasHMSBI;
    private String haTag = "hms_hwid";
    private HiAnalyticsInstance hInstance = null;
    private boolean isEnablePrivacyPolicy = false;
    private ExecutorService reportExecutor = ExecutorsUtils.newSingleThreadExecutor("report_ha");
    private ReportCallBack reportCallback;
    private boolean bReportable = true;
    private boolean bQuicReportable = true;
    private final int random = new SecureRandom().nextInt(1000);
    private boolean bInstallWelink;

    private HianalyticsHelper() {
        try {
            HiAnalyticsManager.getInitFlag((String)DEAULT_HA_SERVICE_TAG);
            this.hasHianalytics = true;
        }
        catch (Throwable e) {
            Logger.i(TAG, "Hianalytics sdk not found");
            this.hasHianalytics = false;
        }
        if (!this.hasHianalytics) {
            this.tryHMSBIInit(ContextHolder.getAppContext());
        }
        try {
            this.bInstallWelink = ContextHolder.getAppContext().getPackageManager().getPackageInfo("com.huawei.works", 0) != null;
        }
        catch (Exception e) {
            this.bInstallWelink = false;
        }
        Logger.v(TAG, "this time the ha %s, mini %s", this.hasHianalytics, this.hasHMSBI);
    }

    private void tryHMSBIInit(Context context) {
        if (context == null) {
            Logger.i(TAG, "the appContext hasn't init");
            return;
        }
        try {
            HMSBIInitializer.getInstance((Context)context).initBI();
            this.hasHMSBI = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Logger.w(TAG, "maybe you need add base sdk!");
        }
        catch (Throwable throwable) {
            Logger.w(TAG, "the hms base has other error!");
        }
    }

    public void setHaTag(String haTag) {
        this.haTag = haTag;
    }

    public void enablePrivacyPolicy(boolean isEnablePrivacyPolicy) {
        this.isEnablePrivacyPolicy = isEnablePrivacyPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HianalyticsHelper getInstance() {
        if (instance != null) return instance;
        Class<HianalyticsHelper> clazz = HianalyticsHelper.class;
        synchronized (HianalyticsHelper.class) {
            if (instance != null) return instance;
            instance = new HianalyticsHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setRate(int rate) {
        if (rate < 0 || rate >= 1000) {
            this.bReportable = true;
            return;
        }
        this.bReportable = this.random < rate || this.bInstallWelink;
        Logger.i(TAG, "bReportable = " + this.bReportable + ", inuser = " + this.bInstallWelink + ", rate = " + rate);
    }

    public void setQuicRate(int quicRate) {
        if (quicRate < 0 || quicRate >= 1000) {
            this.bQuicReportable = true;
            return;
        }
        this.bQuicReportable = this.random < quicRate || this.bInstallWelink;
    }

    public boolean inRate() {
        return this.bReportable;
    }

    public boolean isQuicEnableReport(Context context) {
        return this.isEnableReport(context, true, true);
    }

    public boolean isEnableReport(Context context) {
        return this.isEnableReport(context, true, false);
    }

    public boolean isEnableReportNoSeed(Context context) {
        return this.isEnableReport(context, false, false);
    }

    private boolean isEnableReport(@NonNull Context context, boolean needSeed, boolean quic) {
        if (this.reportCallback != null) {
            return true;
        }
        if (needSeed && (quic && !this.bQuicReportable || !quic && !this.bReportable)) {
            return false;
        }
        if (this.hasHMSBI) {
            return true;
        }
        if (!this.hasHianalytics) {
            return false;
        }
        if (this.isEnablePrivacyPolicy) {
            return this.isHianalyticsOk();
        }
        ContentResolver contentResolver = context.getContentResolver();
        try {
            if (Settings.Secure.getInt((ContentResolver)contentResolver, (String)USER_EXPERIENCE_INVOLVED, (int)-1) == 1) {
                return this.isHianalyticsOk();
            }
        }
        catch (IllegalStateException illegalStateException) {
            Logger.w(TAG, "the setting has illegalStateException");
        }
        catch (Throwable throwable) {
            Logger.w(TAG, "the setting has other error");
        }
        Logger.i(TAG, "user experience involved needs to be opened");
        return false;
    }

    private boolean isHianalyticsOk() {
        if (this.hInstance == null) {
            this.hInstance = HiAnalyticsManager.getInitFlag((String)DEAULT_HA_SERVICE_TAG) ? HiAnalyticsManager.getInstanceByTag((String)DEAULT_HA_SERVICE_TAG) : HiAnalyticsManager.getInstanceByTag((String)this.haTag);
            return this.hInstance != null;
        }
        return true;
    }

    public void onEvent(LinkedHashMap<String, String> data, String eventId) {
        this.onEvent(data, eventId, 1);
    }

    public void onEvent(LinkedHashMap<String, String> data, String eventId, int reportType) {
        if (data == null) {
            return;
        }
        data.put("in_user", "" + (this.bInstallWelink ? 1 : 0));
        Logger.v(TAG, "data = %s", data);
        if (this.reportCallback != null) {
            this.reportCallback.onReport(reportType, eventId, data);
            return;
        }
        if (this.hasHMSBI) {
            this.onNewEvent(ContextHolder.getAppContext(), eventId, data, reportType);
        } else if (reportType == 0) {
            Logger.v(TAG, "the base sdk isn't exsit, and reportType is %s", reportType);
            return;
        }
        if (!this.hasHianalytics) {
            return;
        }
        if (this.hInstance != null) {
            this.hInstance.onEvent(1, eventId, data);
        } else {
            Logger.e(TAG, "the ha has error,has init but is null!");
        }
    }

    private void onNewEvent(Context context, String eventId, Map data, int type) {
        if (context == null || data == null) {
            return;
        }
        Logger.v(TAG, "data = %s", data);
        try {
            HiAnalyticsUtils.getInstance().onNewEvent(context, eventId, data, type);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Logger.w(TAG, "may be you need upgrade stats sdk");
        }
        catch (Throwable throwable) {
            Logger.i(TAG, "the stats has other error,pls check it");
        }
    }

    public void onEvent(LinkedHashMap<String, String> data) {
        this.onEvent(data, "url_request");
    }

    public ExecutorService getReportExecutor() {
        return this.reportExecutor;
    }

    public void executeReportHa(HianalyticsBaseData data, String event) {
        this.getReportExecutor().execute(new HianalyticsRunnable(data, event));
    }

    public void reportException(final Throwable e, final String eventId) {
        if (!HianalyticsHelper.getInstance().isEnableReportNoSeed(ContextHolder.getAppContext())) {
            return;
        }
        final String threadName = Thread.currentThread().getName();
        try {
            this.reportExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    CrashHianalyticsData data = new CrashHianalyticsData();
                    data.put("sdk_version", "7.0.2.301");
                    data.put("crash_type", "exception");
                    data.put("thread_name", threadName);
                    data.put("exception_name", e.getClass().getName());
                    data.put("message", StringUtils.anonymizeMessage(e.getMessage()));
                    data.put("stack_trace", StringUtils.getTraceInfo(e));
                    HianalyticsHelper.getInstance().onEvent(data.get(), eventId);
                }
            });
        }
        catch (RejectedExecutionException ex) {
            Logger.i(TAG, "reportException error RejectedExecutionException");
        }
        catch (Exception exception) {
            Logger.i(TAG, "reportException error!", e);
        }
    }

    public void reportData(Context context, LinkedHashMap<String, String> data, String eventId, int reportType) {
        if (!this.isEnableReportNoSeed(context)) {
            return;
        }
        this.onEvent(data, eventId, reportType);
    }

    public void setReportCallback(ReportCallBack callback) {
        this.reportCallback = callback;
    }

    public static interface ReportCallBack {
        public void onReport(int var1, String var2, LinkedHashMap<String, String> var3);
    }

    private static class HianalyticsRunnable
    implements Runnable {
        private final HianalyticsBaseData data;
        private final String event;

        HianalyticsRunnable(HianalyticsBaseData data, String event) {
            this.data = data;
            this.event = event;
        }

        @Override
        public void run() {
            HianalyticsHelper.getInstance().onEvent(this.data.get(), this.event);
        }
    }
}

