/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common.hianalytics;

import com.huawei.hms.framework.common.Logger;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class HianalyticsBaseData {
    private static final String TAG = "HianalyticsBaseData";
    public static final String SDK_TYPE = "sdk_type";
    public static final String SDK_NAME = "sdk_name";
    public static final String SDK_VERSION = "sdk_version";
    public static final String EVENT_ID = "url_request";
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    private LinkedHashMap<String, String> data = new LinkedHashMap();

    public HianalyticsBaseData() {
        this.data.put(SDK_TYPE, "UxPP");
        this.data.put(SDK_NAME, "networkkit");
    }

    public HianalyticsBaseData put(String key, String value) {
        if (key == null || value == null) {
            Logger.v(TAG, "key = " + key + " : value = " + value);
        } else {
            this.data.put(key, value);
        }
        return this;
    }

    public HianalyticsBaseData put(String key, long value) {
        if (key == null) {
            Logger.v(TAG, "key = null : value = " + value);
        } else {
            this.data.put(key, "" + value);
        }
        return this;
    }

    public HianalyticsBaseData put(LinkedHashMap<String, String> input) {
        if (input == null || input.isEmpty()) {
            Logger.v(TAG, "data is null");
        } else {
            this.data.putAll(input);
        }
        return this;
    }

    public HianalyticsBaseData putIfNotDefault(String key, long value, long defaultValue) {
        if (value == defaultValue) {
            return this;
        }
        return this.put(key, value);
    }

    public LinkedHashMap<String, String> get() {
        return this.data;
    }

    public String toString() {
        JSONObject jsonObject = new JSONObject();
        LinkedHashMap<String, String> temp = this.get();
        try {
            for (Map.Entry<String, String> entry : temp.entrySet()) {
                jsonObject.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (JSONException e) {
            Logger.w(TAG, "catch JSONException", e);
        }
        return jsonObject.toString();
    }
}

