/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common.grs;

import com.huawei.hms.framework.common.StringUtils;
import java.util.Locale;

public class GrsUtils {
    private static final int MAX_GRS_SPLIT = 3;
    private static final int GRS_SERVICE_INDEX = 0;
    private static final int GRS_KEY_INDEX = 1;
    private static final int GRS_PATH_INDEX = 2;
    private static final String SEPARATOR = "/";
    private static final String GRS_SCHEMA = "grs://";

    public static String[] parseParams(String grsUrl) {
        String localGrsUrl = grsUrl;
        if (localGrsUrl.endsWith(SEPARATOR)) {
            int index = localGrsUrl.indexOf(GRS_SCHEMA);
            localGrsUrl = StringUtils.substring(localGrsUrl, index, localGrsUrl.length() - 1);
        }
        return GrsUtils.parseGRSSchema(localGrsUrl);
    }

    public static String[] parseGRSSchema(String grsUrl) {
        int index = grsUrl.toLowerCase(Locale.ENGLISH).indexOf(GRS_SCHEMA);
        String[] split = (grsUrl = StringUtils.substring(grsUrl, index + GRS_SCHEMA.length())).split(SEPARATOR, 3);
        if (split.length == 1) {
            return new String[]{split[0], "ROOT"};
        }
        return split;
    }

    public static String fixResult(String[] params, String result) {
        if (params.length > 2) {
            result = result.endsWith(SEPARATOR) ? result + params[2] : result + SEPARATOR + params[2];
        }
        return result;
    }

    public static boolean isGRSSchema(String endPoint) {
        return endPoint != null && endPoint.startsWith(GRS_SCHEMA);
    }
}

