/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common.check;

import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.Logger;

public class ProviderCheckUtil {
    private static final String TAG = "ProviderCheckUtil";

    public static boolean isValid(Uri uri) {
        if (uri == null) {
            return false;
        }
        PackageManager packageManager = ContextHolder.getAppContext().getPackageManager();
        ProviderInfo providerInfo = packageManager.resolveContentProvider(uri.getAuthority(), 0);
        if (providerInfo == null || providerInfo.applicationInfo == null) {
            Logger.w(TAG, "Invalid param");
            return false;
        }
        String packageName = providerInfo.applicationInfo.packageName;
        Logger.v(TAG, "Target provider service's package name is : " + packageName);
        if (packageName == null) {
            Logger.w(TAG, "Invalid packageName");
            return false;
        }
        return ProviderCheckUtil.checkSignaturesMatch(packageManager, packageName);
    }

    private static boolean checkSignaturesMatch(PackageManager packageManager, String packageName) {
        if (packageManager.checkSignatures("com.huawei.hwid", packageName) == 0) {
            Logger.v(TAG, "Valid Provider");
            return true;
        }
        if (packageManager.checkSignatures("com.huawei.hwid.tv", packageName) == 0) {
            Logger.v(TAG, "Valid Provider in tv");
            return true;
        }
        return false;
    }
}

