/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.common.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PLSharedPreferences {
    private static final String TAG = "PLSharedPreferences";
    private static final String MOVE_TO_DE_RECORDS = "grs_move2DE_records";
    private final SharedPreferences sp;

    public PLSharedPreferences(Context context, String spName) {
        this.sp = this.getSharedPreferences(context, spName);
    }

    private SharedPreferences getSharedPreferences(Context context, String spFileName) {
        SharedPreferences spRecords;
        if (context == null) {
            Logger.e(TAG, "context is null, must call init method to set context");
            return null;
        }
        Context useContext = context;
        if (Build.VERSION.SDK_INT >= 24 && !(spRecords = (useContext = context.createDeviceProtectedStorageContext()).getSharedPreferences(MOVE_TO_DE_RECORDS, 0)).getBoolean(spFileName, false)) {
            if (!useContext.moveSharedPreferencesFrom(context, spFileName)) {
                useContext = context;
            } else {
                SharedPreferences.Editor edt = spRecords.edit();
                edt.putBoolean(spFileName, true);
                edt.apply();
            }
        }
        return useContext.getSharedPreferences(spFileName, 0);
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String defaultValue) {
        if (this.sp == null) {
            return defaultValue;
        }
        return this.sp.getString(key, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        if (this.sp == null) {
            return defaultValue;
        }
        return this.sp.getLong(key, defaultValue);
    }

    public Map<String, String> getHashMap(String key) {
        HashMap<String, String> datas = new HashMap<String, String>();
        if (this.sp == null) {
            return datas;
        }
        String result = this.sp.getString(key, "");
        try {
            JSONArray jsonArray = new JSONArray(result);
            for (int index = 0; index < jsonArray.length(); ++index) {
                JSONObject itemObject = jsonArray.getJSONObject(index);
                JSONArray names = itemObject.names();
                if (names == null) continue;
                for (int nameId = 0; nameId < names.length(); ++nameId) {
                    String name = names.getString(nameId);
                    String value = itemObject.getString(name);
                    datas.put(name, value);
                }
            }
        }
        catch (JSONException e) {
            Logger.w(TAG, "getHashMap parse Json to map error: %s", StringUtils.anonymizeMessage(e.getMessage()));
        }
        return datas;
    }

    public void putString(String key, String value) {
        if (this.sp == null) {
            return;
        }
        this.sp.edit().putString(key, value).apply();
    }

    public void putLong(String key, long value) {
        if (this.sp == null) {
            return;
        }
        this.sp.edit().putLong(key, value).apply();
    }

    public void putHashMap(String key, Map<String, String> datas) {
        if (this.sp == null || datas == null) {
            return;
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject object = new JSONObject();
        for (Map.Entry<String, String> entry : datas.entrySet()) {
            try {
                object.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException e) {
                Logger.w(TAG, "putHashMap one object error: %s", StringUtils.anonymizeMessage(e.getMessage()));
            }
        }
        jsonArray.put((Object)object);
        this.sp.edit().putString(key, jsonArray.toString()).apply();
    }

    public SharedPreferences.Editor edit() {
        if (this.sp == null) {
            return null;
        }
        return this.sp.edit();
    }

    public void removeKeyValue(String key) {
        if (this.sp == null) {
            return;
        }
        this.sp.edit().remove(key).apply();
    }

    public void clear() {
        if (this.sp == null) {
            return;
        }
        this.sp.edit().clear().apply();
    }

    public void remove(String key) {
        if (this.sp == null) {
            return;
        }
        this.sp.edit().remove(key).apply();
    }

    public Map<String, ?> getAll() {
        if (this.sp == null) {
            return null;
        }
        Map map = this.sp.getAll();
        Logger.i(TAG, "sp size " + (map == null ? 0 : map.size()));
        return map;
    }
}

