/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import com.huawei.hms.framework.common.ContextHolder;
import com.huawei.hms.framework.common.IoUtils;
import com.huawei.hms.framework.common.Logger;
import java.io.Closeable;
import java.io.File;

public class NetworkKitSQLiteOpenHelper
extends SQLiteOpenHelper {
    private static final String TAG = "PLSQLiteOpenHelper";
    private static final String DB_NAME_DYNAMIC = "networkkit_dynamic.db";
    private static final String DB_NAME_LOCAL = "networkkit.db";
    private static final String DB_NAME_SUFFIX = "-journal";
    private static String dbName = "networkkit.db";
    public static final int DB_VERSION = 1;
    private static volatile NetworkKitSQLiteOpenHelper instance;

    private NetworkKitSQLiteOpenHelper(Context context, String dbName, int dbVersion) {
        super(context, dbName, null, dbVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetworkKitSQLiteOpenHelper getInstance() {
        if (instance != null) return instance;
        Class<NetworkKitSQLiteOpenHelper> clazz = NetworkKitSQLiteOpenHelper.class;
        synchronized (NetworkKitSQLiteOpenHelper.class) {
            if (instance != null) return instance;
            Context context = Build.VERSION.SDK_INT < 24 ? ContextHolder.getAppContext() : ContextHolder.getAppContext().createDeviceProtectedStorageContext();
            instance = new NetworkKitSQLiteOpenHelper(context, dbName, 1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void onCreate(SQLiteDatabase sqLiteDatabase) {
    }

    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public SQLiteDatabase getNetworkKitWritableDatabase() {
        SQLiteDatabase db = null;
        try {
            db = this.getWritableDatabase();
        }
        catch (Throwable throwable) {
            Logger.e(TAG, "getWritableDatabase db error:" + throwable.getMessage());
        }
        if (db == null) {
            Logger.e(TAG, "getWritableDatabase db is null");
        }
        return db;
    }

    public SQLiteDatabase getNetworkKitReadableDatabase() {
        SQLiteDatabase db = null;
        try {
            db = this.getReadableDatabase();
        }
        catch (Throwable throwable) {
            Logger.e(TAG, "getReadableDatabase db error:" + throwable.getMessage());
        }
        if (db == null) {
            Logger.e(TAG, "getReadableDatabase db is null");
        }
        return db;
    }

    public SQLiteDatabase getNetworkkitUnusedDbDB() {
        String unusedDbName = dbName.equals(DB_NAME_DYNAMIC) ? DB_NAME_LOCAL : DB_NAME_DYNAMIC;
        return this.getDbByName(unusedDbName);
    }

    public SQLiteDatabase getDbByName(String oldDbName) {
        SQLiteDatabase db = this.getNetworkKitReadableDatabase();
        if (db != null) {
            String path = db.getPath().replace(dbName, oldDbName);
            File file = new File(path);
            if (file.exists()) {
                db = SQLiteDatabase.openDatabase((String)path, null, (int)0);
            } else {
                Logger.i(TAG, "old db is not exists");
            }
        }
        return db;
    }

    public boolean deleteDbFile() {
        return this.deleteDbFileByPath(this.getNetworkKitReadableDatabase().getPath());
    }

    public boolean deleteUnusedDbFile() {
        String unusedDbName = dbName.equals(DB_NAME_DYNAMIC) ? DB_NAME_LOCAL : DB_NAME_DYNAMIC;
        String dbPath = this.getNetworkKitReadableDatabase().getPath().replace(dbName, unusedDbName);
        return this.deleteDbFileByPath(dbPath);
    }

    public boolean deleteDbFileByPath(String dbPath) {
        File file = new File(dbPath);
        if (file.exists()) {
            return file.delete();
        }
        Logger.i(TAG, "db is not exists");
        return false;
    }

    public String getDbName() {
        return dbName;
    }

    public String getDbNameSuffix() {
        return DB_NAME_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tabbleIsExistInDB(String dbName, String tableName) {
        boolean result = false;
        if (tableName == null) {
            return result;
        }
        SQLiteDatabase db = this.getNetworkKitReadableDatabase();
        if (db != null) {
            try {
                String dbPath = db.getPath().replace(NetworkKitSQLiteOpenHelper.dbName, dbName);
                db = SQLiteDatabase.openDatabase((String)dbPath, null, (int)0);
                String sql = "select count(1) from " + tableName;
                db.rawQuery(sql, null);
                result = true;
            }
            catch (Throwable e) {
                result = false;
            }
            finally {
                IoUtils.closeSecure((Closeable)db);
            }
        }
        return result;
    }

    static {
        if (ContextHolder.getKitContext() != null) {
            dbName = DB_NAME_DYNAMIC;
        }
    }
}

