/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Log;
import com.huawei.hms.framework.common.ExtLogger;
import com.huawei.hms.framework.common.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.IllegalFormatException;
import org.json.JSONException;

public class Logger {
    private static final boolean DEBUG = false;
    private static final String TAG = "NetworkKit_Logger";
    private static final String SPLIT = "|";
    private static final int MAX_STACK_DEEP_LENGTH_NORMAL = 8;
    private static final int MAX_STACK_DEEP_LENGTH = 20;
    private static final String TAG_NETWORKKIT_PRE = "NetworkKit_";
    private static final String TAG_NETWORK_SDK_PRE = "NetworkSdk_";
    private static ExtLogger extLogger;
    private static boolean kitPrint;

    public static void setExtLogger(ExtLogger logger, boolean kitPrint) {
        extLogger = logger;
        Logger.kitPrint = kitPrint;
        Logger.i(TAG, "logger = " + logger + kitPrint);
    }

    public static void v(String tag, String format, Object ... objects) {
        Logger.println(2, tag, format, objects);
    }

    public static void v(String tag, Object object) {
        Logger.println(2, tag, object);
    }

    @SuppressLint(value={"LogTagMismatch"})
    public static void d(String tag, Object object) {
        Logger.println(3, tag, object);
    }

    @SuppressLint(value={"LogTagMismatch"})
    public static void d(String tag, String format, Object ... objects) {
        Logger.println(3, tag, format, objects);
    }

    @SuppressLint(value={"LogTagMismatch"})
    public static void i(String tag, Object object) {
        Logger.println(4, tag, object);
    }

    @SuppressLint(value={"LogTagMismatch"})
    public static void i(String tag, String format, Object ... objects) {
        Logger.println(4, tag, format, objects);
    }

    public static void w(String tag, Object object) {
        Logger.println(5, tag, object);
    }

    public static void w(String tag, String format, Object ... objects) {
        Logger.println(5, tag, format, objects);
    }

    public static void w(String tag, String msg, Throwable e) {
        if (Logger.isAPPLoggable(5)) {
            extLogger.w(Logger.complexAppTag(tag), Logger.complexMsg(msg, 5), Logger.getNewThrowable(e));
        }
        if (kitPrint) {
            Log.w((String)Logger.complexTag(tag), (String)Logger.complexMsg(msg, 5), (Throwable)Logger.getNewThrowable(e));
        }
    }

    public static void e(String tag, Object object) {
        Logger.println(6, tag, object);
    }

    public static void e(String tag, String format, Object ... objects) {
        Logger.println(6, tag, format, objects);
    }

    public static void e(String tag, String msg, Throwable e) {
        if (Logger.isAPPLoggable(6)) {
            extLogger.e(Logger.complexAppTag(tag), Logger.complexMsg(msg, 5), Logger.getNewThrowable(e));
        }
        if (kitPrint) {
            Log.e((String)Logger.complexTag(tag), (String)Logger.complexMsg(msg, 5), (Throwable)Logger.getNewThrowable(e));
        }
    }

    private static boolean isKitLoggable(int level) {
        return kitPrint && Logger.isLoggable(level);
    }

    private static Throwable getNewThrowable(Throwable e) {
        ThrowableWrapper retWrapper;
        if (Logger.isLoggable(3)) {
            return e;
        }
        if (e == null) {
            return null;
        }
        ThrowableWrapper preWrapper = retWrapper = new ThrowableWrapper(e);
        for (Throwable currThrowable = e.getCause(); currThrowable != null; currThrowable = currThrowable.getCause()) {
            ThrowableWrapper currWrapper = new ThrowableWrapper(currThrowable);
            preWrapper.setCause(currWrapper);
            preWrapper = currWrapper;
        }
        return retWrapper;
    }

    private static String complexTag(String tag) {
        return TAG_NETWORKKIT_PRE + tag;
    }

    private static String complexAppTag(String tag) {
        return TAG_NETWORK_SDK_PRE + tag;
    }

    private static String complexMsg(String msg, int callStackIndex) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            String preInfo = Logger.getCallMethodInfo(callStackIndex);
            return TextUtils.isEmpty((CharSequence)preInfo) ? msg : preInfo + SPLIT + msg;
        }
        return Logger.getCallMethodInfo(callStackIndex);
    }

    public static boolean isLoggable(int level) {
        return Log.isLoggable((String)TAG_NETWORKKIT_PRE, (int)level);
    }

    private static boolean isAPPLoggable(int level) {
        return extLogger != null && level >= 3;
    }

    private static String getCallMethodInfo(int callStackIndex) {
        if (!Log.isLoggable((String)TAG_NETWORKKIT_PRE, (int)3)) {
            return "";
        }
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements.length > callStackIndex) {
            StackTraceElement element = elements[callStackIndex];
            StringBuilder builder = new StringBuilder();
            builder.append(Thread.currentThread().getName()).append(SPLIT).append(element.getFileName()).append(SPLIT).append(element.getClassName()).append(SPLIT).append(element.getMethodName()).append(SPLIT).append(element.getLineNumber());
            return builder.toString();
        }
        return "";
    }

    private static int logPrintln(int priority, String tag, String msg) {
        if (Logger.isAPPLoggable(priority)) {
            Logger.extLogPrintln(priority, Logger.complexAppTag(tag), Logger.complexMsg(msg, 7));
        }
        if (Logger.isKitLoggable(priority)) {
            return Log.println((int)priority, (String)Logger.complexTag(tag), (String)Logger.complexMsg(msg, 7));
        }
        return 1;
    }

    public static void println(int priority, String tag, Object msg) {
        if (priority < 3) {
            return;
        }
        Logger.logPrintln(priority, tag, msg == null ? "null" : msg.toString());
    }

    private static void extLogPrintln(int priority, String tag, String msg) {
        switch (priority) {
            case 2: {
                extLogger.v(tag, msg);
                break;
            }
            case 3: {
                extLogger.d(tag, msg);
                break;
            }
            case 4: {
                extLogger.i(tag, msg);
                break;
            }
            case 5: {
                extLogger.w(tag, msg);
                break;
            }
            case 6: {
                extLogger.e(tag, msg);
                break;
            }
        }
    }

    public static void println(int priority, String tag, String format, Object ... objects) {
        if (priority < 3) {
            return;
        }
        if (format == null) {
            Log.w((String)TAG, (String)"format is null, not log");
            return;
        }
        try {
            Logger.logPrintln(priority, tag, StringUtils.format(format, objects));
        }
        catch (IllegalFormatException e) {
            Logger.w(TAG, "log format error" + format, e);
        }
    }

    static {
        kitPrint = true;
    }

    private static class ThrowableWrapper
    extends Throwable {
        private static final long serialVersionUID = 7129050843360571879L;
        private String message;
        private Throwable thisCause;
        private Throwable ownerThrowable;

        private ThrowableWrapper(Throwable t) {
            this.ownerThrowable = t;
            StackTraceElement[] elements = t.getStackTrace();
            int maxStackDeepLenth = 20;
            if (t instanceof IOException || t instanceof JSONException) {
                maxStackDeepLenth = 8;
            }
            if (elements.length > maxStackDeepLenth) {
                this.setStackTrace(Arrays.copyOf(elements, maxStackDeepLenth));
            } else {
                this.setStackTrace(elements);
            }
            this.setMessage(StringUtils.anonymizeMessage(t.getMessage()));
        }

        @Override
        public synchronized Throwable getCause() {
            return this.thisCause == this ? null : this.thisCause;
        }

        private synchronized void setCause(Throwable cause) {
            this.thisCause = cause;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public String toString() {
            if (this.ownerThrowable == null) {
                return "";
            }
            String throwableClzName = this.ownerThrowable.getClass().getName();
            if (this.message != null) {
                String prefix = throwableClzName + ": ";
                if (this.message.startsWith(prefix)) {
                    return this.message;
                }
                return prefix + this.message;
            }
            return throwableClzName;
        }
    }
}

