/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.common;

import com.huawei.hms.framework.common.ExecutorsEnhance;
import com.huawei.hms.framework.common.ScheduledThreadPoolExecutorEnhance;
import com.huawei.hms.framework.common.ThreadPoolExcutorEnhance;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorsUtils {
    private static final String THREADNAME_HEADER = "NetworkKit_";

    public static ExecutorService newCachedThreadPool(String threadName) {
        ThreadFactory threadFactory = ExecutorsUtils.createThreadFactory(threadName);
        ThreadPoolExcutorEnhance threadPoolExcutorEnhance = new ThreadPoolExcutorEnhance(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        threadPoolExcutorEnhance.allowCoreThreadTimeOut(true);
        return threadPoolExcutorEnhance;
    }

    public static ExecutorService newSingleThreadExecutor(String threadName) {
        ThreadFactory threadFactory = ExecutorsUtils.createThreadFactory(threadName);
        return ExecutorsEnhance.newSingleThreadExecutor(threadFactory);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String threadName) {
        ThreadFactory threadFactory = ExecutorsUtils.createThreadFactory(threadName);
        return new ScheduledThreadPoolExecutorEnhance(corePoolSize, threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String threadName) {
        ThreadFactory threadFactory = ExecutorsUtils.createThreadFactory(threadName);
        ThreadPoolExcutorEnhance threadPoolExcutorEnhance = new ThreadPoolExcutorEnhance(nThreads, nThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        threadPoolExcutorEnhance.allowCoreThreadTimeOut(true);
        return threadPoolExcutorEnhance;
    }

    public static ThreadFactory createThreadFactory(final String threadName) {
        if (threadName == null || threadName.trim().isEmpty()) {
            throw new NullPointerException("ThreadName is empty");
        }
        return new ThreadFactory(){
            private final AtomicInteger threadNumbers = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                return ExecutorsUtils.newThread(runnable, threadName + "_" + this.threadNumbers.getAndIncrement());
            }
        };
    }

    public static Thread newThread(Runnable runnable, String threadName) {
        return new Thread(runnable, THREADNAME_HEADER + threadName);
    }
}

