/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.mlsdk.common;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.Image;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Pair;
import com.huawei.hms.ml.common.utils.ImageConvertUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MLFrame {
    public static final int SCREEN_FIRST_QUADRANT = 0;
    public static final int SCREEN_SECOND_QUADRANT = 1;
    public static final int SCREEN_THIRD_QUADRANT = 2;
    public static final int SCREEN_FOURTH_QUADRANT = 3;
    private Property property;
    private byte[] bytes;
    private ByteBuffer byteBuffer;
    private Bitmap bitmap;
    private volatile Boolean frameInit = false;
    private int recMode;

    public MLFrame() {
        this.property = new Property();
        this.byteBuffer = null;
        this.bitmap = null;
    }

    private MLFrame(ByteBuffer byteBuffer, Property property) {
        this.byteBuffer = byteBuffer;
        this.property = property != null ? property : new Property();
    }

    private MLFrame(byte[] bytes, Property property) {
        this(ByteBuffer.wrap(bytes), property);
    }

    private MLFrame(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    private MLFrame(Bitmap bitmap, Property property) {
        this.bitmap = bitmap;
        this.property = property != null ? property : new Property();
    }

    private MLFrame(byte[] bytes) {
        this.bytes = bytes;
    }

    public Property acquireProperty() {
        return this.property;
    }

    public ByteBuffer acquireGrayByteBuffer() {
        if (null != this.byteBuffer && null != this.property) {
            ImageConvertUtils.nv21ToGray((byte[])this.byteBuffer.array(), (int)this.property.width, (int)this.property.height);
        }
        return this.byteBuffer;
    }

    public int getRecMode() {
        return this.recMode;
    }

    public void setRecMode(int recMode) {
        this.recMode = recMode;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public Bitmap getPreviewBitmap() {
        if (this.bytes == null && this.byteBuffer == null && this.bitmap == null) {
            throw new IllegalStateException("At least one of bytes, byteBuffer or bitmap should be not null");
        }
        return this.wrapBitmap();
    }

    public Bitmap readBitmap() {
        return this.bitmap;
    }

    private final Bitmap wrapBitmap() {
        if (this.bitmap != null) {
            return this.bitmap;
        }
        if (this.property != null) {
            Bitmap raw = null;
            try {
                byte[] data = this.wrapJpeg(false);
                raw = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (Exception e) {
                return null;
            }
            this.bitmap = this.property.getQuadrant() == 0 ? raw : MLFrame.rotate(raw, this.property.getQuadrant());
        }
        return this.bitmap;
    }

    public static MLFrame fromByteBuffer(ByteBuffer byteBuffer, Property property) {
        return new MLFrame(byteBuffer, property);
    }

    public static MLFrame fromByteArray(byte[] bytes, Property property) {
        return new MLFrame(bytes, property);
    }

    public static MLFrame fromBitmap(Bitmap bitmap) {
        return new MLFrame(bitmap);
    }

    @TargetApi(value=19)
    public static MLFrame fromMediaImage(Image image, int quadrant) {
        int format = image.getFormat();
        if (format != 256 && format != 35) {
            throw new IllegalArgumentException("Unsupported format: " + image.getFormat() + ", Only JPEG and YUV_420_888 are supported");
        }
        MLFrame frame = null;
        if (format == 256) {
            Image.Plane[] planes = image.getPlanes();
            if (planes != null && planes.length == 1 && planes[0] != null && planes[0].getBuffer() != null) {
                ByteBuffer buf = planes[0].getBuffer();
                int remaining = buf.remaining();
                byte[] data = new byte[remaining];
                buf.get(data);
                if (quadrant != 0) {
                    Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    Bitmap rotate = MLFrame.rotate(bitmap, quadrant);
                    frame = new MLFrame(rotate);
                } else {
                    frame = new MLFrame(data);
                }
            }
        } else {
            Property.Creator creator = new Property.Creator();
            creator.setFormatType(17).setWidth(image.getWidth()).setHeight(image.getHeight()).setQuadrant(quadrant);
            Property property = creator.create();
            frame = new MLFrame(ImageConvertUtils.getDataFromImage((Image)image, (int)2), property);
        }
        if (frame == null) {
            throw new IllegalStateException("Failed to create frame from media image.");
        }
        return frame;
    }

    public static MLFrame fromFilePath(Context context, Uri uri) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException("Parameter context is mandatory");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Parameter uri is mandatory");
        }
        ContentResolver resolver = context.getContentResolver();
        Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)resolver, (Uri)uri);
        if (bitmap == null) {
            throw new NullPointerException("Failed to load bitmap from uri");
        }
        return new MLFrame(bitmap);
    }

    public final Pair<byte[], Float> create(int width, int height) {
        byte[] jpegBytes;
        int previewHeight;
        if (this.getPreviewSize() == null) {
            return null;
        }
        int previewWidth = (Integer)this.getPreviewSize().first;
        float scale = Math.min((float)width / (float)previewWidth, (float)height / (float)(previewHeight = ((Integer)this.getPreviewSize().second).intValue()));
        if (scale >= 1.0f) {
            scale = 1.0f;
            jpegBytes = this.wrapJpeg(true);
        } else {
            Matrix matrix = new Matrix();
            matrix.postScale(scale, scale);
            Bitmap bitmapTemp = this.wrapBitmap();
            jpegBytes = ImageConvertUtils.bitmap2Jpeg((Bitmap)Bitmap.createBitmap((Bitmap)bitmapTemp, (int)0, (int)0, (int)previewWidth, (int)previewHeight, (Matrix)matrix, (boolean)true), (int)100);
        }
        return Pair.create((Object)jpegBytes, (Object)Float.valueOf(scale));
    }

    private Pair<Integer, Integer> getPreviewSize() {
        if (this.property != null) {
            if (this.property.getItemIdentity() != -1) {
                boolean landscape = this.property.getQuadrant() == 1 || this.property.getQuadrant() == 3;
                return Pair.create((Object)(landscape ? this.property.getHeight() : this.property.getWidth()), (Object)(landscape ? this.property.getWidth() : this.property.getHeight()));
            }
            return Pair.create((Object)this.wrapBitmap().getWidth(), (Object)this.wrapBitmap().getHeight());
        }
        return null;
    }

    public final byte[] wrapJpeg(boolean bitmapOnly) {
        if (this.bytes != null) {
            return this.bytes;
        }
        byte[] jpegBytes = null;
        if (this.byteBuffer != null) {
            int format = this.property.getFormatType();
            if (!this.isSupportedYuvFormat(format)) {
                throw new IllegalStateException("Only support NV21 or YV12");
            }
            if (!bitmapOnly || this.property.getQuadrant() == 0) {
                byte[] bytesTemp = ImageConvertUtils.buffer2Byte((ByteBuffer)this.byteBuffer);
                if (842094169 == format) {
                    bytesTemp = ImageConvertUtils.byteToNv21((byte[])bytesTemp);
                }
                jpegBytes = ImageConvertUtils.nv21ToJpeg((byte[])bytesTemp, (int)this.property.getWidth(), (int)this.property.getHeight());
                if (this.property.getQuadrant() == 0) {
                    this.bytes = jpegBytes;
                }
            }
        }
        if (jpegBytes == null) {
            jpegBytes = ImageConvertUtils.bitmap2Jpeg((Bitmap)this.wrapBitmap(), (int)100);
            this.bytes = jpegBytes;
        }
        return jpegBytes;
    }

    private boolean isSupportedYuvFormat(int format) {
        return format == 842094169 || format == 17;
    }

    public static Bitmap rotate(Bitmap bitmap, int quadrant) {
        if (quadrant < 0 || quadrant > 3) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid quadrant: ").append(quadrant).toString());
        }
        if (quadrant == 0) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)(quadrant * 90));
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public final void initialize() {
        if (this.byteBuffer != null) {
            ByteBuffer buf = this.byteBuffer;
            ByteBuffer newBuffer = ByteBuffer.allocate(buf.capacity());
            buf.rewind();
            newBuffer.put(buf);
            buf.rewind();
            newBuffer.flip();
            this.byteBuffer = newBuffer;
        }
    }

    public final synchronized MLFrame getFrame(boolean bitmapOnly, boolean nv21BufferOnly) {
        if (this.frameInit.booleanValue()) {
            return this;
        }
        if (bitmapOnly || this.byteBuffer == null) {
            this.bitmap = this.getPreviewBitmap();
            this.property = new Creator().setBitmap((Bitmap)this.readBitmap()).create().property;
            this.frameInit = true;
            return this;
        }
        int format = this.property.getFormatType();
        if (!nv21BufferOnly || format == 17) {
            this.frameInit = true;
            return this;
        }
        if (format == 842094169) {
            this.byteBuffer = ByteBuffer.wrap(ImageConvertUtils.byteToNv21((byte[])ImageConvertUtils.buffer2Byte((ByteBuffer)this.byteBuffer)));
        }
        Property.Creator creator = new Property.Creator();
        creator.setFormatType(17).setWidth(this.property.getWidth()).setHeight(this.property.getHeight()).setQuadrant(this.property.getQuadrant());
        this.property = creator.create();
        this.frameInit = true;
        return this;
    }

    public static class Creator {
        private MLFrame frame = new MLFrame();

        public Creator setBitmap(Bitmap bitmap) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            this.frame.bitmap = bitmap;
            Property property = this.frame.acquireProperty();
            property.width = width;
            property.height = height;
            return this;
        }

        public Creator writeByteBufferData(ByteBuffer data, int width, int height, int formatType) {
            if (data == null) {
                throw new IllegalArgumentException("Parameter\uff1a data is not specified");
            }
            if (data.capacity() < width * height) {
                throw new IllegalArgumentException("Not enough capacity for image data size.");
            }
            if (formatType != 17 && formatType != 16 && formatType != 842094169) {
                throw new IllegalArgumentException("Parameter formatType:" + formatType + " is not supported");
            }
            this.frame.byteBuffer = data;
            Property property = this.frame.acquireProperty();
            if (property != null) {
                property.formatType = formatType;
                property.width = width;
                property.height = height;
            }
            return this;
        }

        public Creator setItemIdentity(int itemIdentity) {
            this.frame.acquireProperty().itemIdentity = itemIdentity;
            return this;
        }

        public Creator setTimestamp(long timestamp) {
            this.frame.acquireProperty().timestamp = timestamp;
            return this;
        }

        public Creator setQuadrant(int quad) {
            this.frame.acquireProperty().quadrant = quad;
            return this;
        }

        public Creator setFramePropertyExt(Property.Ext ext) {
            this.frame.acquireProperty().ext = ext;
            return this;
        }

        public MLFrame create() {
            if (this.frame.byteBuffer == null && this.frame.bitmap == null) {
                throw new IllegalStateException("Failed to create image instance, both bitmap and byteBuffer data are not specified.");
            }
            return this.frame;
        }
    }

    public static class Property {
        public static final int SCREEN_FIRST_QUADRANT = 0;
        public static final int SCREEN_SECOND_QUADRANT = 1;
        public static final int SCREEN_THIRD_QUADRANT = 2;
        public static final int SCREEN_FOURTH_QUADRANT = 3;
        public static final int IMAGE_FORMAT_NV21 = 17;
        public static final int IMAGE_FORMAT_YV12 = 842094169;
        private int width;
        private int height;
        private int quadrant = 0;
        private int formatType = -1;
        private int itemIdentity = -1;
        private long timestamp;
        private Ext ext;

        public Property() {
            this.ext = new Ext.Creator().build();
        }

        public Property(Property property) {
            this.width = property.getWidth();
            this.height = property.getHeight();
            this.formatType = property.getFormatType();
            this.quadrant = property.getQuadrant();
            this.itemIdentity = property.getItemIdentity();
            this.timestamp = property.getTimestamp();
            this.ext = property.getExt();
        }

        private Property(int width, int height, int quadrant, int formatType, int itemIdentity, long timestamp, Ext ext) {
            this.width = width;
            this.height = height;
            this.quadrant = quadrant;
            this.formatType = formatType;
            this.itemIdentity = itemIdentity;
            this.timestamp = timestamp;
            this.ext = ext;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getQuadrant() {
            return this.quadrant;
        }

        public int getFormatType() {
            return this.formatType;
        }

        public int getItemIdentity() {
            return this.itemIdentity;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Ext getExt() {
            return this.ext;
        }

        public void resetWidthAndHeight() {
            if (this.quadrant % 2 != 0) {
                int widthTemp = this.width;
                this.width = this.height;
                this.height = widthTemp;
            }
            this.quadrant = 0;
        }

        public static class Creator {
            private int width;
            private int height;
            private int quadrant;
            private int formatType;
            private int itemIdentity;
            private long timestamp;
            private Ext ext;

            public Creator setWidth(int width) {
                this.width = width;
                return this;
            }

            public Creator setHeight(int height) {
                this.height = height;
                return this;
            }

            public Creator setQuadrant(int quadrant) {
                this.quadrant = quadrant;
                return this;
            }

            public Creator setFormatType(int formatType) {
                this.formatType = formatType;
                return this;
            }

            public Creator setItemIdentity(int itemIdentity) {
                this.itemIdentity = itemIdentity;
                return this;
            }

            public Creator setTimestamp(int timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Creator setExt(Ext ext) {
                this.ext = ext;
                return this;
            }

            public Property create() {
                return new Property(this.width, this.height, this.quadrant, this.formatType, this.itemIdentity, this.timestamp, this.ext);
            }
        }

        public static class Ext {
            private int lensId = 0;
            private int maxZoom;
            private int zoom = 0;
            private Rect rect;

            public int getLensId() {
                return this.lensId;
            }

            public int getMaxZoom() {
                return this.maxZoom;
            }

            public int getZoom() {
                return this.zoom;
            }

            public Rect getRect() {
                return this.rect;
            }

            private Ext(int lensId, int zoom, int maxZoom, Rect rect) {
                this.lensId = lensId;
                this.zoom = zoom;
                this.maxZoom = maxZoom;
                this.rect = rect;
            }

            public static class Creator {
                private int lensId = 0;
                private int zoom = 0;
                private int maxZoom;
                private Rect rect;

                public Creator setLensId(int lensId) {
                    this.lensId = lensId;
                    return this;
                }

                public Creator setMaxZoom(int maxZoom) {
                    this.maxZoom = maxZoom;
                    return this;
                }

                public Creator setZoom(int zoom) {
                    this.zoom = zoom;
                    return this;
                }

                public Creator setRect(Rect rect) {
                    this.rect = rect;
                    return this;
                }

                public Ext build() {
                    return new Ext(this.lensId, this.zoom, this.maxZoom, this.rect);
                }
            }
        }
    }
}

