/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.mlsdk.common;

import android.util.SparseArray;
import com.huawei.hms.mlsdk.common.AnalyzerMonitor;
import com.huawei.hms.mlsdk.common.MLFrame;
import com.huawei.hms.mlsdk.common.internal.client.event.MonitorEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class MLAnalyzer<T> {
    private List<AnalyzerMonitor> monitors = new ArrayList<AnalyzerMonitor>();
    private final Object syncAnalyzer = new Object();
    private MLTransactor<T> transactor;

    public void registerMonitor(AnalyzerMonitor monitor) {
        this.monitors.add(monitor);
    }

    public void unregisterMonitor(AnalyzerMonitor monitor) {
        this.monitors.remove(monitor);
    }

    public boolean hasMonitorRegistered() {
        return !this.monitors.isEmpty();
    }

    public void postMonitorEvent(MonitorEvent event) {
        for (AnalyzerMonitor monitor : this.monitors) {
            if (monitor == null) continue;
            monitor.receive(event);
        }
    }

    protected MLFrame.Property.Ext getFramePropertyExt(MLFrame frame) {
        if (frame == null || frame.acquireProperty() == null) {
            return null;
        }
        return frame.acquireProperty().getExt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.syncAnalyzer;
        synchronized (object) {
            if (this.transactor != null) {
                this.transactor.destroy();
                this.transactor = null;
            }
        }
    }

    public abstract SparseArray<T> analyseFrame(MLFrame var1);

    public boolean traceItem(int itemId) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void obtainPicture(MLFrame frame) {
        Object object = this.syncAnalyzer;
        synchronized (object) {
            if (this.transactor == null) {
                throw new IllegalStateException("Transactor must be specified first to receive detection results.");
            }
            MLFrame.Property property = new MLFrame.Property(frame.acquireProperty());
            property.resetWidthAndHeight();
            Result<T> result = new Result<T>(this.analyseFrame(frame), property, this.isAvailable());
            this.transactor.transactResult(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactor(MLTransactor<T> transactor) {
        Object object = this.syncAnalyzer;
        synchronized (object) {
            this.transactor = transactor;
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public static class Result<T> {
        private SparseArray<T> analyseList;
        private MLFrame.Property frameProperty;
        private boolean isAnalyzerAvailable;

        public Result(SparseArray<T> analyseList, MLFrame.Property frameProperty, boolean isAnalyzerAvailable) {
            this.analyseList = analyseList;
            this.frameProperty = frameProperty;
            this.isAnalyzerAvailable = isAnalyzerAvailable;
        }

        public SparseArray<T> getAnalyseList() {
            return this.analyseList;
        }

        public MLFrame.Property getFrameProperty() {
            return this.frameProperty;
        }

        public boolean isAnalyzerAvaliable() {
            return this.isAnalyzerAvailable;
        }
    }

    public static interface MLTransactor<T> {
        public void destroy();

        public void transactResult(Result<T> var1);
    }
}

