/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.mlsdk.common;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.YuvImage;
import com.huawei.hms.ml.common.utils.StreamUtils;
import com.huawei.hms.mlsdk.common.MLFrame;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class BitmapUtils {
    private static final String TAG = "BitmapUtils";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmap(ByteBuffer data, MLFrame.Property property) {
        Bitmap bitmap;
        ByteArrayOutputStream stream = null;
        try {
            data.rewind();
            byte[] imageInBuffer = new byte[data.limit()];
            data.get(imageInBuffer, 0, imageInBuffer.length);
            YuvImage image = new YuvImage(imageInBuffer, 17, property.getWidth(), property.getHeight(), null);
            stream = new ByteArrayOutputStream();
            image.compressToJpeg(new Rect(0, 0, property.getWidth(), property.getHeight()), 100, (OutputStream)stream);
            Bitmap bmp = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
            bitmap = BitmapUtils.rotateBitmap(bmp, property.getQuadrant());
        }
        catch (Throwable throwable) {
            StreamUtils.closeStreams((Closeable[])new Closeable[]{stream});
            throw throwable;
        }
        StreamUtils.closeStreams((Closeable[])new Closeable[]{stream});
        return bitmap;
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, int quadrant) {
        Matrix matrix = new Matrix();
        int rotationDegree = 0;
        switch (quadrant) {
            case 1: {
                rotationDegree = 90;
                break;
            }
            case 2: {
                rotationDegree = 180;
                break;
            }
            case 3: {
                rotationDegree = 270;
                break;
            }
        }
        matrix.postRotate((float)rotationDegree);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap cut(Bitmap original, Point[] border, int padding) {
        if (original == null || border == null || border.length != 4) {
            return null;
        }
        for (Point p : border) {
            if (p != null) continue;
            return null;
        }
        Point leftTop = border[0];
        Point rightTop = border[1];
        Point rightBottom = border[2];
        double rad = Math.atan2(rightTop.y - leftTop.y, rightTop.x - leftTop.x);
        float degrees = (float)Math.toDegrees(rad);
        if (Math.abs((int)degrees) <= 0) {
            return BitmapUtils.cutPaddingExtendRect(original, leftTop, rightBottom, 0, 0, padding);
        }
        int originalWidth = original.getWidth();
        int originalHeight = original.getHeight();
        Point originalCenter = new Point(originalWidth >> 1, originalHeight >> 1);
        Matrix matrix = new Matrix();
        matrix.setRotate(-degrees, (float)(originalWidth >> 1), (float)(originalHeight >> 1));
        Bitmap rotate = Bitmap.createBitmap((Bitmap)original, (int)0, (int)0, (int)originalWidth, (int)originalHeight, (Matrix)matrix, (boolean)true);
        int rotateWidth = rotate.getWidth();
        int rotateHeight = rotate.getHeight();
        int offsetX = rotateWidth - originalWidth >> 1;
        int offsetY = rotateHeight - originalHeight >> 1;
        Point rotateLeftTop = BitmapUtils.rotateCoordinate(original, originalCenter, leftTop, rad);
        Point rotateRightBottom = BitmapUtils.rotateCoordinate(original, originalCenter, rightBottom, rad);
        return BitmapUtils.cutPaddingExtendRect(rotate, rotateLeftTop, rotateRightBottom, offsetX, offsetY, padding);
    }

    private static Point rotateCoordinate(Bitmap source, Point relative, Point current, double rad) {
        int height = source.getHeight();
        int x1 = current.x;
        int y1 = height - current.y;
        int x2 = relative.x;
        int y2 = height - relative.y;
        int x = (int)((double)(x1 - x2) * Math.cos(rad) - (double)(y1 - y2) * Math.sin(rad) + (double)x2);
        int y = (int)((double)(x1 - x2) * Math.sin(rad) + (double)(y1 - y2) * Math.cos(rad) + (double)y2);
        return new Point(x, height - y);
    }

    private static Bitmap cutPaddingExtendRect(Bitmap source, Point leftTop, Point rightBottom, int offsetX, int offsetY, int padding) {
        int bottom;
        int right;
        int top;
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int left = leftTop.x + offsetX - padding;
        if (left < 0) {
            left = 0;
        }
        if ((top = leftTop.y + offsetY - padding) < 0) {
            top = 0;
        }
        if ((right = rightBottom.x + offsetX + padding) > sourceWidth) {
            right = sourceWidth;
        }
        if ((bottom = rightBottom.y + offsetY + padding) > sourceHeight) {
            bottom = sourceHeight;
        }
        return Bitmap.createBitmap((Bitmap)source, (int)left, (int)top, (int)(right - left), (int)(bottom - top));
    }
}

