/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.mlsdk.common;

import java.util.Arrays;

public final class AppSettingHolder<T> {
    private final String persistenceKey;
    private final T setting;

    public static <T> AppSettingHolder<T> create(String persistenceKey, T setting) {
        return new AppSettingHolder<T>(persistenceKey, setting);
    }

    private AppSettingHolder(String persistenceKey, T setting) {
        if (persistenceKey == null) {
            throw new NullPointerException("Null PersistentKey");
        }
        if (setting == null) {
            throw new NullPointerException("Null setting");
        }
        this.persistenceKey = persistenceKey;
        this.setting = setting;
    }

    public final String toString() {
        String persistenceKeyStr = this.persistenceKey;
        String options = String.valueOf(this.setting);
        return new StringBuilder(97 + String.valueOf(persistenceKeyStr).length() + String.valueOf(options).length()).append("MlModelDriverInstanceKey{persistentKey=").append(persistenceKeyStr).append(", setting=").append(this.setting).append("}").toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AppSettingHolder) {
            AppSettingHolder holder = (AppSettingHolder)object;
            return this.persistenceKey.equals(holder.persistenceKey) && this.setting.equals(holder.setting);
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.persistenceKey, this.setting});
    }
}

